/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.glpi;

/**
 * Information about a Glpi ticket (id, title, status)
 */
public class GlpiTicket
{
    /** The id of ticket */
    private int _id;

    /** The title of ticket */
    private String _title;

    /** The status id of ticket */
    private int _status;

    private int _type;
    private String _category;
    
    /**
     * Create a {@link GlpiTicket}
     * @param id The id of ticket
     * @param title The title of ticket
     * @param status The status id of ticket
     */
    public GlpiTicket(int id, String title, int status)
    {
        this(id,  title, status, -1, null);  
    }
    
    /**
     * Create a {@link GlpiTicket}
     * @param id The id of ticket
     * @param title The title of ticket
     * @param status The status id of ticket
     * @param type The type
     * @param category The category
     */
    public GlpiTicket(int id, String title, int status, int type, String category)
    {
        _id = id;
        _title = title;
        _status = status;
        _category = category;
        _type = type;    
    }

    /**
     * Get the id of ticket
     * @return The id of ticket
     */
    public int getId()
    {
        return _id;
    }

    /**
     * Set the id of ticket
     * @param id The id of ticket to set
     */
    public void setId(int id)
    {
        this._id = id;
    }

    /**
     * Get the title of ticket
     * @return The title of ticket
     */
    public String getTitle()
    {
        return _title;
    }

    /**
     * Set the title of ticket
     * 
     * @param title The title of ticket to set
     */
    public void setTitle(String title)
    {
        this._title = title;
    }

    /**
     * Get the status id of ticket
     * @return The status of ticket
     */
    public int getStatusId()
    {
        return _status;
    }

    /**
     * Set the status id of ticket
     * @param status The status id of ticket to set
     */
    public void setStatus(int status)
    {
        this._status = status;
    }
    
    /**
     * Get the category of ticket
     * @return the category
     */
    public String getCategory()
    {
        return _category;
    }

    /**
     * Set the category of ticket
     * @param category the category
     */
    public void setCategory(String category)
    {
        this._category = category;
    }
    
    /**
     * Get the type of ticket
     * @return the type or -1 if not defined
     */
    public int getType()
    {
        return _type;
    }

    /**
     * Set the type of ticket
     * @param type the type
     */
    public void setType(int type)
    {
        this._type = type;
    }
}
