/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.glpi;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.glpi.GlpiTicket;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class TicketGlpiManager
extends AbstractLogEnabled
implements Component,
Initializable,
Serviceable,
PluginAware {
    public static final String ROLE = TicketGlpiManager.class.getName();
    private static final String __GLPI_INIT_SESSION = "/initSession/";
    private static final String __GLPI_SEARCH_USERS = "/search/User/";
    private static final String __GLPI_SEARCH_TICKET = "/search/Ticket/";
    private static final String __GLPI_KILL_SESSION = "/killSession/";
    protected long _maxCacheSize;
    protected long _cacheTtl;
    protected LoadingCache<UserIdentity, Map<String, Object>> _cache;
    protected Cache<String, Integer> _cacheIdentities;
    private JSONUtils _jsonUtils;
    private Map<Integer, I18nizableText> _glpiStatus;
    private Map<Integer, I18nizableText> _glpiType;
    private String _pluginName;

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    public void initialize() {
        GlpiCacheLoader loader = new GlpiCacheLoader();
        Long maxCacheSizeConf = (Long)Config.getInstance().getValue("org.ametys.plugins.glpi.maxsize");
        Long maxCacheSize = maxCacheSizeConf != null ? maxCacheSizeConf.intValue() : 1000;
        Long cacheTtlConf = (Long)Config.getInstance().getValue("org.ametys.plugins.glpi.ttl");
        Long cacheTtl = cacheTtlConf != null && cacheTtlConf.intValue() >= 0 ? cacheTtlConf.intValue() : 60;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(cacheTtl.longValue(), TimeUnit.MINUTES);
        if (maxCacheSize > 0L) {
            cacheBuilder.maximumSize(maxCacheSize.longValue());
        }
        this._cache = cacheBuilder.build((CacheLoader)loader);
        maxCacheSizeConf = (Long)Config.getInstance().getValue("org.ametys.plugins.glpi.maxsize.identities");
        maxCacheSize = maxCacheSizeConf != null ? maxCacheSizeConf.intValue() : 5000;
        cacheTtlConf = (Long)Config.getInstance().getValue("org.ametys.plugins.glpi.ttl.identities");
        cacheTtl = cacheTtlConf != null && cacheTtlConf.intValue() >= 0 ? cacheTtlConf.intValue() : 60;
        CacheBuilder cacheIdentitiesBuilder = CacheBuilder.newBuilder().expireAfterWrite(cacheTtl.longValue(), TimeUnit.MINUTES);
        if (maxCacheSize > 0L) {
            cacheIdentitiesBuilder.maximumSize(maxCacheSize.longValue());
        }
        this._cacheIdentities = cacheIdentitiesBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> loadUserInfo(final UserIdentity userIdentity) throws Exception {
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        final String glpiUrl = (String)Config.getInstance().getValue("org.ametys.plugins.glpi.url");
        String usertoken = (String)Config.getInstance().getValue("org.ametys.plugins.glpi.usertoken");
        final String apptoken = (String)Config.getInstance().getValue("org.ametys.plugins.glpi.apptoken");
        if (glpiUrl == null || usertoken == null || apptoken == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Missing configuration: unable to contact the GLPI WebService Rest API, the configuration is incomplete.");
            }
            return userInfo;
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).build();
        try (final CloseableHttpClient httpclient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).useSystemProperties().build();){
            final String sessionToken = this._getGlpiSessionToken(httpclient, glpiUrl, usertoken, apptoken);
            if (sessionToken == null) {
                HashMap<String, Object> hashMap = userInfo;
                return hashMap;
            }
            try {
                Integer userId = (Integer)this._cacheIdentities.get((Object)userIdentity.getLogin().toLowerCase(), (Callable)new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return TicketGlpiManager.this.getUserIdentity(httpclient, userIdentity, glpiUrl, sessionToken, apptoken);
                    }
                });
                if (userId != null && userId != -1) {
                    Map<String, Object> glpiOpenTickets = this.getGlpiTickets(httpclient, glpiUrl, sessionToken, apptoken, userId);
                    if (glpiOpenTickets != null && !glpiOpenTickets.isEmpty()) {
                        userInfo.put("countOpenTickets", glpiOpenTickets.get("countOpenTickets"));
                        userInfo.put("openTickets", glpiOpenTickets.get("openTickets"));
                    }
                } else {
                    this.getLogger().debug("GPLI identity not found for user {}", (Object)userIdentity);
                }
            }
            finally {
                this._killGlpiSessionToken(httpclient, glpiUrl, sessionToken, apptoken);
            }
        }
        return userInfo;
    }

    private String _getGlpiSessionToken(CloseableHttpClient httpclient, String glpiUrl, String usertoken, String apptoken) throws IOException, URISyntaxException {
        Map<String, Object> jsonObject;
        URIBuilder builder = new URIBuilder(glpiUrl + __GLPI_INIT_SESSION).addParameter("user_token", usertoken).addParameter("app_token", apptoken);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Call GLPI webservice to init session : " + String.valueOf(builder.build()));
        }
        if ((jsonObject = this._callWebServiceApi(httpclient, builder.build(), true)) != null && jsonObject.containsKey("session_token")) {
            String token = (String)jsonObject.get("session_token");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("GPLI WS returned session token '" + token + "'");
            }
            return token;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("GPLI WS returned no session token for user token '" + usertoken + "'");
        }
        return null;
    }

    protected Integer getUserIdentity(CloseableHttpClient httpclient, UserIdentity userIdentity, String glpiUrl, String sessionToken, String apptoken) throws Exception {
        Long maxIdentitiesSize = (Long)Config.getInstance().getValue("org.ametys.plugins.glpi.maxsize.identities");
        URIBuilder builder = new URIBuilder(glpiUrl + __GLPI_SEARCH_USERS).addParameter("range", "0-" + (maxIdentitiesSize != null ? maxIdentitiesSize : 1000L)).addParameter("forcedisplay[0]", "1").addParameter("forcedisplay[1]", "2").addParameter("criteria[0][field]", "8").addParameter("criteria[0][searchtype]", "contains").addParameter("criteria[0][value]", "1").addParameter("session_token", sessionToken).addParameter("app_token", apptoken);
        Map<String, Object> jsonObject = this._callWebServiceApi(httpclient, builder.build(), true);
        if (jsonObject != null && jsonObject.containsKey("data")) {
            List data = (List)jsonObject.get("data");
            Map userIdentities = data.stream().filter(user -> StringUtils.isNotEmpty((CharSequence)((String)user.get("1"))) && user.containsKey("2")).collect(Collectors.toConcurrentMap(user -> ((String)user.get("1")).toLowerCase(), user -> (Integer)user.get("2"), (int1, int2) -> {
                this.getLogger().warn(String.format("GLPI id '%d' and '%d' are linked to the same login. '%d' will be ignored", int1, int2, int2));
                return int1;
            }));
            this._cacheIdentities.putAll(userIdentities);
            if (userIdentities.containsKey(userIdentity.getLogin().toLowerCase())) {
                return (Integer)userIdentities.get(userIdentity.getLogin().toLowerCase());
            }
        }
        return -1;
    }

    protected Map<String, Object> getGlpiTickets(CloseableHttpClient httpclient, String glpiUrl, String sessionToken, String apptoken, Integer userId) throws IOException, URISyntaxException {
        Map<String, Object> jsonObject;
        StringBuilder uri = new StringBuilder(glpiUrl + "/search/Ticket/?");
        uri.append(this.getTicketSearchQuery(userId)).append("&session_token=").append(sessionToken).append("&app_token=").append(apptoken);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Call GLPI webservice to search tickets : " + uri.toString());
        }
        if ((jsonObject = this._callWebServiceApi(httpclient, new URI(uri.toString()), true)) != null) {
            HashMap<String, Object> glpiTicketsInfo = new HashMap<String, Object>();
            if (jsonObject.containsKey("totalcount")) {
                glpiTicketsInfo.put("countOpenTickets", jsonObject.get("totalcount"));
            }
            if (jsonObject.containsKey("data")) {
                Object dataObject = jsonObject.get("data");
                ArrayList<GlpiTicket> glpiTickets = new ArrayList<GlpiTicket>();
                if (dataObject instanceof List) {
                    List dataList = (List)dataObject;
                    for (Object object : dataList) {
                        if (!(object instanceof Map)) continue;
                        Map ticketData = (Map)object;
                        glpiTickets.add(this.parseTicket(ticketData));
                    }
                    glpiTicketsInfo.put("openTickets", glpiTickets);
                }
            }
            return glpiTicketsInfo;
        }
        return null;
    }

    protected GlpiTicket parseTicket(Map<String, Object> data) {
        int ticketId = (Integer)data.get("2");
        String ticketTitle = (String)data.get("1");
        int status = (Integer)data.get("12");
        int type = data.containsKey("14") ? (Integer)data.get("14") : -1;
        String category = (String)data.get("7");
        GlpiTicket ticket = new GlpiTicket(ticketId, ticketTitle, status, type, category);
        return ticket;
    }

    protected String getTicketSearchQuery(Integer userId) {
        StringBuilder sb = new StringBuilder();
        sb.append("forcedisplay[0]=1").append("&forcedisplay[1]=12").append("&forcedisplay[2]=4").append("&forcedisplay[3]=2").append("&forcedisplay[4]=7").append("&forcedisplay[6]=14").append("&criteria[0][field]=12&criteria[0][searchtype]=0&criteria[0][value]=notold").append("&criteria[1][link]=AND").append("&criteria[1][field]=4&criteria[1][searchtype]=equals&criteria[1][value]=" + userId).append("&sort=4");
        return sb.toString();
    }

    private void _killGlpiSessionToken(CloseableHttpClient httpclient, String glpiUrl, String sessionToken, String apptoken) throws IOException, URISyntaxException {
        URIBuilder builder = new URIBuilder(glpiUrl + __GLPI_KILL_SESSION).addParameter("session_token", sessionToken).addParameter("app_token", apptoken);
        this._callWebServiceApi(httpclient, builder.build(), false);
    }

    private Map<String, Object> _callWebServiceApi(CloseableHttpClient httpclient, URI uri, boolean getJsonObject) throws IOException {
        block23: {
            HttpGet get = new HttpGet(uri);
            try (CloseableHttpResponse httpResponse = httpclient.execute((HttpUriRequest)get);){
                if (!this._isSuccess(httpResponse.getStatusLine().getStatusCode())) {
                    ByteArrayOutputStream bos;
                    String msg = null;
                    if (httpResponse.getEntity() != null) {
                        bos = new ByteArrayOutputStream();
                        try (InputStream is = httpResponse.getEntity().getContent();){
                            IOUtils.copy((InputStream)is, (OutputStream)bos);
                        }
                        msg = bos.toString("UTF-8");
                    }
                    this.getLogger().error("An error occurred while contacting the GLPI Rest API (status code : " + httpResponse.getStatusLine().getStatusCode() + "). Response is : " + msg);
                    bos = null;
                    return bos;
                }
                if (!getJsonObject) break block23;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try (InputStream is = httpResponse.getEntity().getContent();){
                    IOUtils.copy((InputStream)is, (OutputStream)bos);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("GLPI webservice at uri " + String.valueOf(uri) + " returned : " + bos.toString("UTF-8"));
                }
                Map map = this._jsonUtils.convertJsonToMap(bos.toString("UTF-8"));
                return map;
            }
        }
        return null;
    }

    private boolean _isSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public int getCountOpenTickets(UserIdentity userIdentity) {
        if (userIdentity == null) {
            throw new IllegalArgumentException("User is not connected");
        }
        Map userInfo = (Map)this._cache.getUnchecked((Object)userIdentity);
        if (userInfo.get("countOpenTickets") != null) {
            return (Integer)userInfo.get("countOpenTickets");
        }
        return -1;
    }

    public List<GlpiTicket> getOpenTickets(UserIdentity userIdentity) {
        if (userIdentity == null) {
            throw new IllegalArgumentException("User is not connected");
        }
        Map userInfo = (Map)this._cache.getUnchecked((Object)userIdentity);
        if (userInfo.get("openTickets") != null) {
            return (List)userInfo.get("openTickets");
        }
        return Collections.EMPTY_LIST;
    }

    public I18nizableText getGlpiStatusLabel(int status) {
        if (this._glpiStatus == null) {
            this._glpiStatus = new HashMap<Integer, I18nizableText>();
            this._glpiStatus.put(1, new I18nizableText("plugin." + this._pluginName, "PLUGINS_GLPI_INCOMMING_STATUS"));
            this._glpiStatus.put(2, new I18nizableText("plugin." + this._pluginName, "PLUGINS_GLPI_ASSIGNED_STATUS"));
            this._glpiStatus.put(3, new I18nizableText("plugin." + this._pluginName, "PLUGINS_GLPI_PLANNED_STATUS"));
            this._glpiStatus.put(4, new I18nizableText("plugin." + this._pluginName, "PLUGINS_GLPI_WAITING_STATUS"));
            this._glpiStatus.put(5, new I18nizableText("plugin." + this._pluginName, "PLUGINS_GLPI_SOLVED_STATUS"));
            this._glpiStatus.put(6, new I18nizableText("plugin." + this._pluginName, "PLUGINS_GLPI_CLOSED_STATUS"));
        }
        return this._glpiStatus.get(status);
    }

    public I18nizableText getGlpiTypeLabel(int type) {
        if (this._glpiType == null) {
            this._glpiType = new HashMap<Integer, I18nizableText>();
            this._glpiType.put(1, new I18nizableText("plugin." + this._pluginName, "PLUGINS_GLPI_INCIDENT_TYPE"));
            this._glpiType.put(2, new I18nizableText("plugin." + this._pluginName, "PLUGINS_GLPI_DEMAND_TYPE"));
        }
        return this._glpiType.get(type);
    }

    protected class GlpiCacheLoader
    extends CacheLoader<UserIdentity, Map<String, Object>> {
        protected GlpiCacheLoader() {
        }

        public Map<String, Object> load(UserIdentity userIdentity) throws Exception {
            return TicketGlpiManager.this.loadUserInfo(userIdentity);
        }
    }
}

