/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.hyperplanning;

import com.indexeducation.hyperplanning.ApiClient;
import com.indexeducation.hyperplanning.api.VersionApi;
import java.util.List;
import org.ametys.core.util.HttpUtils;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class HyperplanningConnectionChecker
implements ItemChecker,
Configurable {
    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] config = configuration.getChild("linked-params").getChildren();
        if (config.length != 3) {
            throw new ConfigurationException("The HyperplanningChecker should have 3 linked params in the right order: url, login, password");
        }
    }

    public void check(List<String> values) throws ItemCheckerTestFailureException {
        String url = HttpUtils.sanitize((String)values.get(0));
        String login = values.get(1);
        String password = values.get(2);
        try {
            ApiClient client = new ApiClient();
            client.setBasePath(url + "/hpsw/api/v1");
            client.setUsername(login);
            client.setPassword(password);
            new VersionApi(client).versionGet(null);
        }
        catch (Exception e) {
            throw new ItemCheckerTestFailureException((Throwable)e);
        }
    }
}

