/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.hyperplanning.dynamic;

import java.time.format.FormatStyle;
import java.util.Map;
import java.util.Set;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.hyperplanning.HyperplanningManager;
import org.ametys.plugins.linkdirectory.dynamic.AbstractInternalDynamicInformationGenerator;
import org.ametys.plugins.linkdirectory.dynamic.DynamicInformationException;
import org.ametys.runtime.i18n.I18nizableDateTime;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CancelledLessonsDynamicInformationGenerator
extends AbstractInternalDynamicInformationGenerator {
    private HyperplanningManager _hyperplanningManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._hyperplanningManager = (HyperplanningManager)((Object)serviceManager.lookup(HyperplanningManager.ROLE));
    }

    protected void saxShortValue() throws SAXException, DynamicInformationException {
        UserIdentity currentUser = this.getCurrentUser();
        if (currentUser == null) {
            throw new DynamicInformationException("Unable to retrieve hyperplanning data, user is not connected", DynamicInformationException.ExceptionType.UNAUTHORIZED);
        }
        Set<HyperplanningManager.CancelledLesson> cancelledLessons = this._getLessons(currentUser);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"short-value", (String)String.valueOf(cancelledLessons.size()));
    }

    protected void saxLongValue() throws SAXException, DynamicInformationException {
        UserIdentity currentUser = this.getCurrentUser();
        if (currentUser == null) {
            throw new DynamicInformationException("Unable to retrieve hyperplanning data, user is not connected", DynamicInformationException.ExceptionType.UNAUTHORIZED);
        }
        Set<HyperplanningManager.CancelledLesson> cancelledLessons = this._getLessons(currentUser);
        int count = cancelledLessons.size();
        if (count == 0) {
            I18nizableText longValue = new I18nizableText("plugin.hyperplanning", "PLUGIN_HYPERPLANNING_DYNAMIC_INFORMATION_CANCELLED_LESSONS_NO_ELEMENT");
            longValue.toSAX(this.contentHandler, "long-value");
        } else if (count == 1) {
            I18nizableText longValue = new I18nizableText("plugin.hyperplanning", "PLUGIN_HYPERPLANNING_DYNAMIC_INFORMATION_CANCELLED_LESSONS_NB_ELEMENT", Map.of("count", new I18nizableText(Integer.toString(count))));
            longValue.toSAX(this.contentHandler, "long-value");
        } else {
            I18nizableText longValue = new I18nizableText("plugin.hyperplanning", "PLUGIN_HYPERPLANNING_DYNAMIC_INFORMATION_CANCELLED_LESSONS_NB_ELEMENTS", Map.of("count", new I18nizableText(Integer.toString(count))));
            longValue.toSAX(this.contentHandler, "long-value");
        }
    }

    protected void saxTooltips() throws SAXException, DynamicInformationException {
        UserIdentity currentUser = this.getCurrentUser();
        if (currentUser == null) {
            throw new DynamicInformationException("Unable to retrieve hyperplanning data, user is not connected", DynamicInformationException.ExceptionType.UNAUTHORIZED);
        }
        Set<HyperplanningManager.CancelledLesson> cancelledLessons = this._getLessons(currentUser);
        int maxItems = this.getMaxItems();
        cancelledLessons.stream().limit(maxItems != -1 ? (long)maxItems : (long)cancelledLessons.size()).forEach(lesson -> {
            try {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"item");
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)(lesson.code() + " " + (StringUtils.isNotBlank((CharSequence)lesson.fullLabel()) ? lesson.fullLabel() : lesson.label())));
                I18nizableText summary = new I18nizableText("plugin.hyperplanning", "PLUGIN_HYPERPLANNING_DYNAMIC_INFORMATION_CANCELLED_LESSONS_SUMMARY", Map.of("date", new I18nizableDateTime(lesson.date(), lesson.date().getZone(), FormatStyle.MEDIUM)));
                summary.toSAX(this.contentHandler, "summary");
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"footer", (String)(lesson.cancelRationale() + " " + lesson.cancelComment()));
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"item");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Set<HyperplanningManager.CancelledLesson> _getLessons(UserIdentity currentUser) {
        try {
            return this._hyperplanningManager.getUpcomingCancelledLessons(currentUser);
        }
        catch (Exception e) {
            throw new DynamicInformationException("An error occured while retrieving data from hyperplanning", (Throwable)e);
        }
    }
}

