/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.hyperplanning;

import java.util.List;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.core.util.HttpUtils;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;

import com.indexeducation.hyperplanning.ApiClient;
import com.indexeducation.hyperplanning.api.VersionApi;

/**
 * Connection checker for hyperplanning
 */
public class HyperplanningConnectionChecker implements ItemChecker, Configurable
{
    public void configure(Configuration configuration) throws ConfigurationException
    {
        Configuration[] config = configuration.getChild("linked-params").getChildren();
        if (config.length != 3)
        {
            throw new ConfigurationException("The HyperplanningChecker should have 3 linked params in the right order: url, login, password");
        }
    }

    public void check(List<String> values) throws ItemCheckerTestFailureException
    {
        String url = HttpUtils.sanitize(values.get(0));
        String login = values.get(1);
        String password = values.get(2);
        
        try
        {
            ApiClient client = new ApiClient();
            client.setBasePath(url + "/hpsw/api/v1");
            client.setUsername(login);
            client.setPassword(password);

            new VersionApi(client).versionGet(null);
        }
        catch (Exception e)
        {
            throw new ItemCheckerTestFailureException(e);
        }
    }
}
