<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="http://exslt.org/math"
                exclude-result-prefixes="resolver math">

    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="gdpr:youtube-playlist"/>
    
    <xsl:variable name="service-title" select="string(ametys:serviceParameter('header')/text())"/>
    <xsl:variable name="playlistId" select="ametys:serviceParameter('playlist')/text()"/>
    <xsl:variable name="apiKey" select="ametys:siteParameter('google-api-key')"/>
    
    <xsl:variable name="player-theme">light</xsl:variable>
    <xsl:variable name="player-color">color</xsl:variable>
    
    <xsl:variable name="player-min-width">200</xsl:variable>
    <xsl:variable name="player-min-height">200</xsl:variable>
    <xsl:variable name="player-min-max-elements">1</xsl:variable>
    <xsl:variable name="player-default-width">400</xsl:variable>
    <xsl:variable name="player-default-height">321</xsl:variable>
    <xsl:variable name="player-default-max-elements">200</xsl:variable>
    
    <xsl:variable name="player-width">
        <xsl:choose>
            <xsl:when test="ametys:serviceParameter('width')/text() = ''"><xsl:value-of select="$player-default-width"/></xsl:when>
            <xsl:when test="number(ametys:serviceParameter('width')) &lt; number($player-min-width)"><xsl:value-of select="$player-min-width"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="ametys:serviceParameter('width')"/></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="player-height">
        <xsl:choose>
            <xsl:when test="ametys:serviceParameter('height')/text() = ''"><xsl:value-of select="$player-default-height"/></xsl:when>
            <xsl:when test="number(ametys:serviceParameter('height')) &lt; number($player-min-height)"><xsl:value-of select="$player-min-height"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="ametys:serviceParameter('height')"/></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="player-max-elements">
        <xsl:choose>
            <xsl:when test="not(ametys:serviceParameter('maxElements'))"><xsl:value-of select="$player-default-max-elements"/></xsl:when>
            <xsl:when test="number(ametys:serviceParameter('maxElements')) &lt; number($player-min-max-elements)"><xsl:value-of select="$player-min-max-elements"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="ametys:serviceParameter('maxElements')"/></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="common-service-css-class-name">youtube-playlist</xsl:variable>
    <xsl:variable name="is-empty" select="false()"/> 
    <xsl:variable name="common-service-name-id">service-youtube-playlist</xsl:variable>    
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$service-title"/>                    
        </xsl:call-template>
    </xsl:template>
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$service-title"/>
        </xsl:call-template>    
    </xsl:template>
        
    <!-- User in common.xsl -->
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:pluginResourceURL('inlinemedia', 'js/playlist.js')}"/>
        <script type="text/javascript">
            // Register player
            configArray.push({'uniqueId': '<xsl:value-of select="$uniqueId"/>',
                'playlistId': '<xsl:value-of select="$playlistId"/>',
                'height': '<xsl:value-of select="$player-height"/>',
                'width': '<xsl:value-of select="$player-width"/>',
                'maxElements': '<xsl:value-of select="$player-max-elements"/>',
                'template': <xsl:call-template name="playlist-template"/>
            });
            apiKey = '<xsl:value-of select="$apiKey"/>';
        </script>
        
        <xsl:call-template name="youtube-playlist-js">
            <xsl:with-param name="uniqueId" select="$uniqueId" />
            <xsl:with-param name="playlistId" select="$playlistId" />
        </xsl:call-template>
    </xsl:template>    
    
    <!-- User in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:if test="normalize-space($apiKey) = ''">
            <xsl:call-template name="empty-api-key"/>
        </xsl:if>
        <div style="display: none" name="ieDisplay">
               <!-- Message to display for Internet Explorer users -->
               <i18n:text  i18n:catalogue="plugin.core-ui" i18n:key="PLUGINS_CORE_UI_UNSUPPORTED_BROWSER_HEAD"/>
        </div>
        
        <xsl:call-template name="youtube-playlist-body">
            <xsl:with-param name="uniqueId" select="$uniqueId" />
            <xsl:with-param name="width" select="$player-width" />
            <xsl:with-param name="height" select="$player-height" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="empty-api-key">
        <xsl:if test="$rendering-context = 'back'">
            <div class="ametys-cms-zone-item-error">
                <table cellspacing="0" cellpadding="0">
                    <tr>
                        <td style="vertical-align: top; width: 36px;"><img alt="" src="{$uri-prefix}/plugins/web/resources/img/skin/zoneitem_error_32.png"/></td>
                        <td><i18n:text i18n:key="PLUGINS_INLINEMEDIA_SERVICE_VIDEOYOUTUBEGALLERY_APIKEY_ERROR_TITLE"/></td>
                    </tr>
                </table>
                <div class="exception-message">
                    <i18n:text i18n:key="PLUGINS_INLINEMEDIA_SERVICE_VIDEOYOUTUBEGALLERY_APIKEY_ERROR_DESC"/>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="playlist-template">
            "&lt;li>&lt;a title='{title}' href='#player_{uniqueId}' onclick='loadVideo(\"{uniqueId}\",{position}); return true;'>&lt;img alt='{title}' src='{defaultUrl}'/>&lt;span class='title'>{title}&lt;/span>&lt;span class='time' id='time_{videoId}'>{duration}&lt;/span>&lt;/a>&lt;/li>"
    </xsl:template>
    
</xsl:stylesheet>
