<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<!--DOCTYPE xsl:stylesheet PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "xhtml1-transitional.dtd"-->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                exclude-result-prefixes="resolver">
     
    <xsl:import href="gdpr:youtube" /> 
    <xsl:import href="gdpr:dailymotion" /> 
                
    <xsl:param name="prefix"/>
    <xsl:param name="rendering-context"/>
    
    <xsl:template match="media[@data-ametys-type = 'youtube']">
        <xsl:variable name="width" select="substring-before(@width, 'px')"/>
        <xsl:variable name="height" select="substring-before(@depth, 'px')"/>

        <xsl:call-template name="youtube">
		    <xsl:with-param name="width" select="$width" />
		    <xsl:with-param name="height" select="$height" />
		    <xsl:with-param name="videoId" select="@href" />
		</xsl:call-template>
    </xsl:template>
    
    <xsl:template match="media[@data-ametys-type = 'dailymotion']">
        <xsl:variable name="width" select="substring-before(@width, 'px')"/>
        <xsl:variable name="height" select="substring-before(@depth, 'px')"/>
        
        <xsl:call-template name="dailymotion">
            <xsl:with-param name="width" select="$width" />
            <xsl:with-param name="height" select="$height" />
            <xsl:with-param name="videoId" select="@href" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="media[@type='video']">
        <xsl:variable name="srcResolved" select="resolver:resolve(@data-ametys-type, @href)"/>
        <xsl:variable name="width" select="substring-before(@width, 'px')"/>
        <xsl:variable name="height" select="substring-before(@depth, 'px')"/>
        <xsl:variable name="playerId" select="generate-id(.)"/>
        
        <div class="{../@class}" id="player-{$playerId}">
            <xsl:attribute name="style">width:100%; min-width: 250px; <xsl:if test="$width != ''">max-width:<xsl:value-of select="$width"/>px;</xsl:if><xsl:if test="$height != ''">max-height:<xsl:value-of select="$height"/>px</xsl:if></xsl:attribute>
        	<video id="video-{$playerId}"></video>
        </div>
        
        <script type="text/javascript">
            baseUrl<xsl:value-of select="$playerId"/> = new RegExp('^(https?:\/\/[^\/]+)(\/.*)?').exec(window.location.href)[1];
            $j(document).ready(function() {
            	new MediaElementPlayer(video-<xsl:value-of select="$playerId"/>', {
                    stretching: 'responsive',
                    success: function(media) {
   						media.setSrc(baseUrl<xsl:value-of select="$playerId"/> + "<xsl:value-of select="$srcResolved"/>";
   						media.load();
  					}
                });
            });
        </script>  
        <xsl:if test="@alt">
            <noscript>
                <p><xsl:value-of select="@alt"/></p>
            </noscript> 
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="media[@type='audio']">
        <xsl:variable name="srcResolved" select="resolver:resolve(@data-ametys-type, @href)"/>
        <xsl:variable name="width" select="substring-before(@width, 'px')"/>
        <xsl:variable name="playerId" select="generate-id(.)"/>
        
        <div class="{../@class}" id="player-{$playerId}">
            <xsl:attribute name="style">width:100%; min-width: 250px; <xsl:if test="$width != ''">max-width:<xsl:value-of select="$width"/>px</xsl:if></xsl:attribute>
        	<audio id="audio-{$playerId}"></audio>
        </div>
        
        <script type="text/javascript">
            baseUrl<xsl:value-of select="$playerId"/> = new RegExp('^(https?:\/\/[^\/]+)(\/.*)?').exec(window.location.href)[1];
            $j(document).ready(function() {
            	new MediaElementPlayer(video-<xsl:value-of select="$playerId"/>', {
                    stretching: 'responsive',
                    success: function(media) {
   						media.setSrc(baseUrl<xsl:value-of select="$playerId"/> + "<xsl:value-of select="$srcResolved"/>";
   						media.load();
  					}
                });
            });
        </script>  
        <xsl:if test="@alt">
            <noscript>
                <p><xsl:value-of select="@alt"/></p>
            </noscript> 
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>