<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:stringutils="org.apache.commons.lang.StringUtils"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    exclude-result-prefixes="ametys">

    <xsl:template name="youtube-playlist-js" >
        <xsl:param name="uniqueId" />
        <xsl:param name="playlistId" />
        
        <script type="text/javascript">
            $j(document).ready(function() {
                initYoutubePlaylist('<xsl:value-of select="$uniqueId" />', '<xsl:value-of select="$playlistId" />');
            });
        </script>
    </xsl:template>

    <xsl:template name="youtube-playlist-body" >
        <xsl:param name="uniqueId" />
        <xsl:param name="class" />
        <xsl:param name="width" />
        <xsl:param name="height" />
        
        <div id="player_{$uniqueId}" class="video-player ${class}" style="width: {$width}px; height: {$height}px"></div>
        
        <ul id="playlist_{$uniqueId}" class="video-playlist ${class}"  style="display:none; height: {$height}px"></ul>
        <div style="clear: both"></div>
    </xsl:template>
    
</xsl:stylesheet>
