<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://docbook.org/ns/docbook"
	xmlns:html="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:math="http://exslt.org/math" xmlns:dyn="http://exslt.org/dynamic"
	xmlns:xalan="http://xml.apache.org/xalan" xmlns:editor="org.ametys.cms.transformation.xslt.InlineEditorHelper"
	xmlns:xlink="http://www.w3.org/1999/xlink" exclude-result-prefixes="math dyn xalan editor">

	<xsl:output method="xml" indent="yes" />

    <xsl:template match="img[@marker = 'marker' and @media]">
        <xsl:variable name="class" select="@flash"/>
        <mediaobject type="{@media}">
        	<xsl:if test="substring-after(@class, concat($class, ' ')) != ''">
                <xsl:attribute name="class"><xsl:value-of select="substring-after(@class, concat($class, ' '))"/></xsl:attribute>
			</xsl:if>
        
            <xsl:if test="@align">
                <xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
            </xsl:if>

            <xsl:if test="@alt">
                <alt><xsl:value-of select="@alt"/></alt>
            </xsl:if>
            
            <xsl:variable name="width" select="editor:getStyleValue(@style, 'width', concat(@width, 'px'))"/>
            <xsl:variable name="height" select="editor:getStyleValue(@style, 'height', concat(@height, 'px'))"/>
            
            <xsl:choose>
            	<xsl:when test="@media = 'audio'">
            		<audioobject>
            			<audiodata fileref="{@data-ametys-src}" type="{@data-ametys-type}">
            				 <xsl:if test="$width != ''"><xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute></xsl:if>
            				 <xsl:if test="$height != ''"><xsl:attribute name="depth"><xsl:value-of select="$height"/></xsl:attribute></xsl:if>
            			</audiodata>
            		</audioobject>
            	</xsl:when>
            	<xsl:otherwise>
					<videoobject>
		                <videodata fileref="{@data-ametys-src}" type="{@data-ametys-type}">
		                    <xsl:if test="$width != ''"><xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute></xsl:if>
		                    <xsl:if test="$height != ''"><xsl:attribute name="depth"><xsl:value-of select="$height"/></xsl:attribute></xsl:if>
		                </videodata>
		        	</videoobject>
            	</xsl:otherwise>
            </xsl:choose>
        </mediaobject>
	</xsl:template>
	
</xsl:stylesheet>
