/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

var nextVideo = nextVideo || 0;
var configArray = configArray || [];
var ytPlayerMap = ytPlayerMap || {};
var maxElementsMap = maxElementsMap || {};
var apiKey = apiKey || null;

function initYoutubePlaylist(uniqueId, playlistId)
{
    document.getElementById("player_" + uniqueId).setAttribute("src", (document.location.protocol == 'https:' ? 'https:' : 'http:') + "//www.youtube.com/embed/videoseries?list=" + playlistId + "&listType=playlist");
 
    var scriptElt = document.createElement('script');
    scriptElt.src = "//www.youtube.com/iframe_api";
    var firstScriptTag = document.getElementsByTagName('script')[0];
    firstScriptTag.parentNode.insertBefore(scriptElt, firstScriptTag);
}

function onYouTubeIframeAPIReady ()
{
    if(navigator.userAgent.indexOf('MSIE')!==-1 || navigator.appVersion.indexOf('Trident/') > -1)
    {
        /* Microsoft Internet Explorer detected in. */
        $j("div[name='ieDisplay']").show();
        $j("td[id^=player_]").hide();
        $j("td[id^=playlist_]").hide();
    }
    else
    {
        loadNextVideo()
    }
}

function loadNextVideo ()
{
    if(configArray.length > nextVideo)
    {
        var config = configArray[nextVideo]
        var playerId = config.uniqueId;
        var playlistId = config.playlistId;
        var template = config.template;
        var player = new YT.Player("player_" + playerId, 
        {
            height: config.height,
            width: config.width,
            playerVars: {autoplay: 0}, 
            events: {onReady: function (){onPlayerReady(playerId,playlistId )}}
        });
        
        ytPlayerMap[playerId] = player;
        maxElementsMap[playerId] = config.maxElements || 200;
        nextVideo++;
        displayPlayList(playerId, playlistId, template);
    }
}

function onPlayerReady (playerId, playlistId)
{
    var player = ytPlayerMap[playerId];
    
    player.cuePlaylist({
        list: playlistId,
        listType: 'playlist',
        index: 0,
        startSeconds: 0
    });
    loadNextVideo();
}

function displayPlayList (uniqueId, playlistId, template)
{
	var divPlayer = $j('#player_' + uniqueId);
	var w = divPlayer.parent().width();
	var oW = divPlayer.outerWidth(true);
		
	var list = $j('#playlist_' + uniqueId);
	var listW = w - oW; 
	if (listW < 200)
	{
		list.width(w);
	}
	else
	{
		list.width(listW);
	}
	list.show();
	
	if(maxElementsMap[uniqueId] > 1)
    {
        //We only display first 200 videos, as Youtube API does not allow to exceed this limit, 
        //like #playVideoAt function that will not work with index greater than 200 .
	    addVideos (uniqueId, playlistId, null, Math.min(200, maxElementsMap[uniqueId]), template, -1, 0);
    }
}

/*
 * uniqueId: The id of the video player.
 * videoId: The ID that YouTube uses to uniquely identify a video.
 * title: The video's title.
 * description: The video's description. 
 * publishedAt: The date and time that the item was added to the playlist. 
 * position: The order in which the item appears in the playlist. The value uses a zero-based index, so the first item has a position of 0, the second item has a position of 1, and so forth.
 * defaultUrl: The default thumbnail image, 120px wide and 90px tall.
 * mediumUrl: A higher resolution version of the thumbnail image, 320px wide and 180px tall.
 * highUrl: A high resolution version of the thumbnail image, 480px wide and 360px tall.
 * duration: The length of the video. A request is needed to know the time, so it's replaced temporarily by a span, and by text once the request has ended.
 */
function replaceTemplate (template, vars)
{
    template = template.replace(/\{uniqueId\}/g, vars.uniqueId)
    template = template.replace(/\{videoId\}/g, vars.videoId)
    template = template.replace(/\{title\}/g, vars.title)
    template = template.replace(/\{description\}/g, vars.description)
    template = template.replace(/\{publishedAt\}/g, vars.publishedAt)
    template = template.replace(/\{position\}/g, vars.position)
    template = template.replace(/\{defaultUrl\}/g, vars.defaultUrl)
    template = template.replace(/\{mediumUrl\}/g, vars.mediumUrl)
    template = template.replace(/\{highUrl\}/g, vars.highUrl)
    template = template.replace(/\{duration\}/g, "<span name='time" + vars.videoId + "'>")
    return template;
}

function addVideos (uniqueId, playlistId, pageToken, maxResults, template, previousIndex, skippedResults)
{
    
    var playlistURL = 'https://www.googleapis.com/youtube/v3/playlistItems?part=snippet,contentDetails&maxResults=' + Math.min(50, maxResults) + '&playlistId=' + playlistId + '&key=' + apiKey;
    if (pageToken != null)
	{
		playlistURL += "&pageToken=" + pageToken;
	}

	$j.getJSON(playlistURL, function(data)
	{
		if (data.items != null)
		{
		    var contentDetailsURL = 'https://www.googleapis.com/youtube/v3/videos?part=contentDetails&key=' + apiKey;
		    $j.each(data.items, function(i, item)
			{
				var title = item.snippet.title.replace(/'/g,"&#039;").replace(/"/g,"&#034;");
				var videoId = item.snippet.resourceId.videoId;
				var position = previousIndex + 1;
				if(position + skippedResults != item.snippet.position)
				{
                    skippedResults = item.snippet.position - position;
				}
                previousIndex = position;
				    
				contentDetailsURL += "&id=" + videoId
				
				var vars = {
				        uniqueId: uniqueId,
				        videoId: videoId,
				        title: title,
                        description: item.snippet.description,
                        publishedAt: item.snippet.publishedAt,
                        position: position,
                        defaultUrl: item.snippet.thumbnails['default'].url,
                        mediumUrl: item.snippet.thumbnails['medium'].url,
                        highUrl: item.snippet.thumbnails['high'].url
				}
				
				var htmlCode = replaceTemplate(template, vars);
				$j('#playlist_' + uniqueId).append(htmlCode);
			});

		    $j.getJSON(contentDetailsURL, function(contentDetails)
		    {
	            $j.each(contentDetails.items, function(i, item)
                {
	                var temps = item.contentDetails.duration;
	                temps = temps.substring(2).toLowerCase();
	                $j("span[name='time"+ item.id + "']").replaceWith(temps);
                });
		    });
		}
		
		if (data.nextPageToken)
		{
            maxResults = maxElementsMap[uniqueId] - previousIndex - 1;
            if(maxResults > 0)
            {
                addVideos (uniqueId, playlistId, data.nextPageToken, maxResults, template, previousIndex, skippedResults);
            }
		}
	});
}

function loadVideo(playerId, pos)
{
    playVideo(playerId, pos);
}


function playVideo (playerId, videoIndex)
{
    ytPlayerMap[playerId].playVideoAt(videoIndex);
}
