<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:docbook="http://docbook.org/ns/docbook"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	xmlns:math="http://exslt.org/math"
	xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper" 
	xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:javamath="java.lang.Math"
	exclude-result-prefixes="docbook resolver ametys math">
    
    <xsl:import href="gdpr:youtube" />
    <xsl:import href="gdpr:dailymotion" />
    
	<xsl:variable name="uri-prefix" select="ametys:uriPrefix()" />
    <xsl:variable name="rendering-context" select="ametys:renderingContext()"/>
    
    <xsl:template name="inlinemedia-video-style">
        <xsl:param name="width"/>
        <xsl:param name="height"/>
        <xsl:param name="videoId"/>
    
        <style>
            .video_wrapper#video_wrapper_<xsl:value-of select="$videoId"/> {
                max-width: <xsl:value-of select="$width"/>px;
                max-height: <xsl:value-of select="$height"/>px;
                width: 100%; 
                display: inline-block;
            }
            
            .video_wrapper#video_wrapper_<xsl:value-of select="$videoId"/> > * {
                <xsl:variable name="ratio" select="$height div $width * 100"/>
                display: block; 
                position: relative; 
                <xsl:if test="$ratio != ''">padding-bottom: <xsl:value-of select="$ratio"/>%;</xsl:if>
            }
            .video_wrapper#video_wrapper_<xsl:value-of select="$videoId"/> iframe {
                width:100%;
                height:100%;
                position:absolute;
                left:0px;
                top:0px;
            }
        </style>
    </xsl:template>
    
    <xsl:template match="docbook:videoobject[docbook:videodata/@type = 'youtube']">
        <xsl:variable name="width" select="substring-before(docbook:videodata/@width, 'px')"/>
        <xsl:variable name="height" select="substring-before(docbook:videodata/@depth, 'px')"/>
        <xsl:variable name="videoId" select="docbook:videodata/@fileref"/>

        <xsl:call-template name="inlinemedia-video-style">
            <xsl:with-param name="width" select="$width"/>
            <xsl:with-param name="height" select="$height"/>
            <xsl:with-param name="videoId" select="$videoId"/>
        </xsl:call-template>
        
		<xsl:variable name="iframeId" select="concat('iframe_', $videoId)"/> 
        
        <span class='video_wrapper video_youtube_wrapper {../@class}' id="video_wrapper_{$videoId}">
            <span>
        		<xsl:call-template name="youtube">
        		  <xsl:with-param name="id" select="$iframeId" />
        		  <xsl:with-param name="class" select="../@class" />
                  <xsl:with-param name="width" select="$width" />
                  <xsl:with-param name="height" select="$height" />
                  <xsl:with-param name="videoId" select="$videoId" />
                </xsl:call-template>
            </span>
        </span>
    </xsl:template>
    
    <xsl:template match="docbook:videoobject[docbook:videodata/@type = 'dailymotion']">
        <xsl:variable name="width" select="substring-before(docbook:videodata/@width, 'px')"/>
        <xsl:variable name="height" select="substring-before(docbook:videodata/@depth, 'px')"/>
        <xsl:variable name="videoId" select="docbook:videodata/@fileref"/>

        <xsl:call-template name="inlinemedia-video-style">
            <xsl:with-param name="width" select="$width"/>
            <xsl:with-param name="height" select="$height"/>
            <xsl:with-param name="videoId" select="$videoId"/>
        </xsl:call-template>
        
		<xsl:variable name="iframeId" select="concat('iframe_', $videoId)"/> 
		
        <span class='video_wrapper video_dailymotion_wrapper {../@class}' id="video_wrapper_{$videoId}">
            <span>
        		<xsl:call-template name="dailymotion">
                  <xsl:with-param name="id" select="$iframeId" />
                  <xsl:with-param name="class" select="../@class" />
                  <xsl:with-param name="width" select="$width" />
                  <xsl:with-param name="height" select="$height" />
                  <xsl:with-param name="videoId" select="$videoId" />
                </xsl:call-template>
            </span>
        </span>
    </xsl:template>
    
    <xsl:template match="docbook:mediaobject[@type = 'video']/docbook:videoobject">
    	<xsl:variable name="width" select="substring-before(docbook:videodata/@width, 'px')"/>
        <xsl:variable name="height" select="substring-before(docbook:videodata/@depth, 'px')"/>
        <xsl:variable name="playerId" select="generate-id(.)"/>
        
        <span class="ametys-media-player {../@class}" id="player-{$playerId}">
            <xsl:attribute name="style">display: inline-block; width:100%; min-width: 250px; <xsl:if test="$width != ''">max-width:<xsl:value-of select="javamath:max(250, $width)"/>px;</xsl:if><xsl:if test="$height != ''">max-height:<xsl:value-of select="javamath:max(250, $width)*($height div $width)"/>px</xsl:if></xsl:attribute>
        	<video id="video-{$playerId}"></video>
        </span>
        
        <script type="text/javascript">
            baseUrl<xsl:value-of select="$playerId"/> = new RegExp('^(https?:\/\/[^\/]+)(\/.*)?').exec(window.location.href)[1];
            $j(document).ready(function() {
            	new MediaElementPlayer('video-<xsl:value-of select="$playerId"/>', {
            		stretching: 'responsive',
               	 	success: function(media) {
   						media.setSrc(baseUrl<xsl:value-of select="$playerId"/> + "<xsl:value-of select="resolver:resolve(docbook:videodata/@type, docbook:videodata/@fileref)"/>");
   						media.load();
  					}
            	});
            });
        </script>  
        <xsl:if test="../docbook:alt">
            <noscript>
                <p><xsl:value-of select="../docbook:alt"/></p>
            </noscript> 
        </xsl:if>
    </xsl:template>
    
     <xsl:template match="docbook:mediaobject[@type = 'audio']/docbook:audioobject">
    	<xsl:variable name="width" select="substring-before(docbook:audiodata/@width, 'px')"/>
        <xsl:variable name="playerId" select="generate-id(.)"/>
        
        <span class="{../@class}" id="player-{$playerId}">
            <xsl:attribute name="style">display: inline-block; width:100%; min-width: 250px; <xsl:if test="$width != ''">max-width:<xsl:value-of select="$width"/>px</xsl:if></xsl:attribute>
        	<audio id="audio-{$playerId}"></audio>
        </span>
        
        <script type="text/javascript">
            baseUrl<xsl:value-of select="$playerId"/> = new RegExp('^(https?:\/\/[^\/]+)(\/.*)?').exec(window.location.href)[1];
            $j(document).ready(function() {
            	new MediaElementPlayer('audio-<xsl:value-of select="$playerId"/>', {
            		stretching: 'responsive',
               	 	success: function(media) {
   						media.setSrc(baseUrl<xsl:value-of select="$playerId"/> + "<xsl:value-of select="resolver:resolve(docbook:audiodata/@type, docbook:audiodata/@fileref)"/>");
   						media.load();
  					}
            	});
            });
        </script>  
        <xsl:if test="../docbook:alt">
            <noscript>
                <p><xsl:value-of select="../docbook:alt"/></p>
            </noscript> 
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
