<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:math="http://exslt.org/math"
	xmlns:dyn="http://exslt.org/dynamic"
	xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:editor="org.ametys.cms.transformation.xslt.InlineEditorHelper"
	exclude-result-prefixes="math dyn xalan editor">
	
	<xsl:output method="xml" indent="yes"/>
	
    <xsl:template match="img[@marker = 'marker' and @media]">
        <xsl:variable name="class" select="@flash"/>
        <media type="{@media}">
        	<xsl:if test="substring-after(@class, concat($class, ' ')) != ''">
                <xsl:attribute name="class"><xsl:value-of select="substring-after(@class, concat($class, ' '))"/></xsl:attribute>
			</xsl:if>
        
            <xsl:copy-of select="@alt"/>
            
            <xsl:if test="@align">
            	 <xsl:copy-of select="@align"/>
            </xsl:if>
            
            <xsl:variable name="width" select="editor:getStyleValue(@style, 'width', concat(@width, 'px'))"/>
            <xsl:variable name="height" select="editor:getStyleValue(@style, 'height', concat(@height, 'px'))"/>
            
            <xsl:if test="$width != ''"><xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute></xsl:if>
            <xsl:if test="$height != ''"><xsl:attribute name="depth"><xsl:value-of select="$height"/></xsl:attribute></xsl:if>
            
            <xsl:attribute name="href"><xsl:value-of select="@data-ametys-src"/></xsl:attribute>
            <xsl:attribute name="data-ametys-type"><xsl:value-of select="@data-ametys-type"/></xsl:attribute>
        </media>
    </xsl:template>
</xsl:stylesheet>
