/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

AmetysImagesPlugin.registerMenuItem({
                    icon: 'embed',
                    text: "{{i18n plugin.inlinemedia:PLUGINS_INLINEMEDIA_EDITOR_MENUVIDEO_INSERT_LABEL}}",
                    tooltip: "{{i18n plugin.inlinemedia:PLUGINS_INLINEMEDIA_EDITOR_MENUVIDEO_INSERT_DESCRIPTION}}",
                    type: 'nestedmenuitem',
                    onSetup: function(component, editor) {
                        AmetysImagesPlugin.createHideMenuOnNodeChangeListener(component, false, editor)
                    },
                    submenuitems: [
                            {
                                icon: 'embed',
                                type: 'menuitem',
                                text: "{{i18n plugin.inlinemedia:PLUGINS_INLINEMEDIA_EDITOR_LOCAL_INSERT_LABEL}}",
                                tooltip: "{{i18n plugin.inlinemedia:PLUGINS_INLINEMEDIA_EDITOR_LOCAL_INSERT_DESCRIPTION}}",
                                action: function(editor) {
                                    Ametys.plugins.inlinemedia.Media._insertLocalVideo(
                                        editor,
                                        "ametysicon-movie16",
                                        AmetysImagesPlugin.UPLOAD_URL
                                    );
                                },
                                onSetup: function(component, editor) {
			                        AmetysImagesPlugin.createHideMenuOnNodeChangeListener(component, false, editor)
			                    }
                            },
                            {
                                icon: 'embed',
                                type: 'menuitem',
                                text: "{{i18n plugin.inlinemedia:PLUGINS_INLINEMEDIA_EDITOR_RESOURCES_INSERT_LABEL}}",
                                tooltip: "{{i18n plugin.inlinemedia:PLUGINS_INLINEMEDIA_EDITOR_RESOURCES_INSERT_DESCRIPTION}}",
                                action: function(editor) {
                                    Ametys.plugins.inlinemedia.Media._insertResourceVideo(
                                        editor,
                                        "ametysicon-movie16 decorator-ametysicon-world91",
                                        false
                                    );
                                },
                                onSetup: function(component, editor) {
                                    AmetysImagesPlugin.createHideMenuOnNodeChangeListener(component, false, editor)
                                }
                            },
                            {
                                icon: 'embed',
                                type: 'menuitem',
                                text: "{{i18n plugin.inlinemedia:PLUGINS_INLINEMEDIA_EDITOR_YOUTUBE_INSERT_LABEL}}",
                                tooltip: "{{i18n plugin.inlinemedia:PLUGINS_INLINEMEDIA_EDITOR_YOUTUBE_INSERT_DESCRIPTION}}",
                                onSetup: function(component) { createHideMenuOnNodeChangeListener(component, false); },
                                action: function(editor) {
                                    Ametys.plugins.inlinemedia.Media._insertYoutube(
                                        editor,
                                        "ametysicon-trademark-youtube"
                                    );
                                },
                                onSetup: function(component, editor) {
                                    AmetysImagesPlugin.createHideMenuOnNodeChangeListener(component, false, editor)
                                }
                            },
                            {
                                icon: 'embed',
                                type: 'menuitem',
                                text: "{{i18n plugin.inlinemedia:PLUGINS_INLINEMEDIA_EDITOR_DAILYMOTION_INSERT_LABEL}}",
                                tooltip: "{{i18n plugin.inlinemedia:PLUGINS_INLINEMEDIA_EDITOR_DAILYMOTION_INSERT_DESCRIPTION}}",
                                onSetup: function(component) { createHideMenuOnNodeChangeListener(component, false); },
                                action: function(editor) {
                                    Ametys.plugins.inlinemedia.Media._insertDailymotion(
                                        editor,
                                        "ametysicon-movie16"
                                    );
                                },
                                onSetup: function(component, editor) {
                                    AmetysImagesPlugin.createHideMenuOnNodeChangeListener(component, false, editor)
                                }
                            }
                        ]
                    }, "content", 2);

