<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:docbook="http://docbook.org/ns/docbook"
	xmlns:html="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
	exclude-result-prefixes="docbook xlink html resolver">

	<xsl:param name="contextPath" />
	<xsl:param name="workspaceName" />
	<xsl:param name="workspaceURI" />

    <xsl:template match="docbook:videoobject">
        <img src="{$contextPath}/plugins/inlinemedia/resources/img/trans.gif" data-ametys-src="{docbook:videodata/@fileref}" data-ametys-type="{docbook:videodata/@type}" marker="marker" media="{../@type}">
            <xsl:attribute name="class">
                <xsl:value-of select="../@type"/>
                <xsl:if test="../@class"><xsl:text> </xsl:text><xsl:value-of select="../@class"/></xsl:if>
            </xsl:attribute>
           
            <xsl:if test="../docbook:alt">
                <xsl:attribute name="alt"><xsl:value-of select="../docbook:alt"/></xsl:attribute>
            </xsl:if>
            
            <xsl:if test="docbook:videodata/@width"><xsl:attribute name="width"><xsl:value-of select="substring-before(docbook:videodata/@width, 'px')"/></xsl:attribute></xsl:if>
            <xsl:if test="docbook:videodata/@depth"><xsl:attribute name="height"><xsl:value-of select="substring-before(docbook:videodata/@depth, 'px')"/></xsl:attribute></xsl:if>
            <xsl:if test="docbook:videodata/@align"><xsl:attribute name="align"><xsl:value-of select="docbook:videodata/@align"/></xsl:attribute></xsl:if>
        </img>
    </xsl:template>
    
    <xsl:template match="docbook:audioobject">
        <img src="{$contextPath}/plugins/inlinemedia/resources/img/trans.gif" data-ametys-src="{docbook:audiodata/@fileref}" data-ametys-type="{docbook:audiodata/@type}" marker="marker" media="{../@type}">
            <xsl:attribute name="class">
                <xsl:value-of select="../@type"/>
                <xsl:if test="../@class"><xsl:text> </xsl:text><xsl:value-of select="../@class"/></xsl:if>
            </xsl:attribute>
           
            <xsl:if test="../docbook:alt">
                <xsl:attribute name="alt"><xsl:value-of select="../docbook:alt"/></xsl:attribute>
            </xsl:if>
            
            <xsl:if test="docbook:audiodata/@width"><xsl:attribute name="width"><xsl:value-of select="substring-before(docbook:audiodata/@width, 'px')"/></xsl:attribute></xsl:if>
            <xsl:if test="docbook:audiodata/@depth"><xsl:attribute name="height"><xsl:value-of select="substring-before(docbook:audiodata/@depth, 'px')"/></xsl:attribute></xsl:if>
            <xsl:if test="docbook:audiodata/@align"><xsl:attribute name="align"><xsl:value-of select="docbook:audiodata/@align"/></xsl:attribute></xsl:if>
        </img>
    </xsl:template>

</xsl:stylesheet>
