/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.link;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.plugins.linkdirectory.repository.DefaultLink;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LinksGenerator
extends ServiceableGenerator {
    private static final String __DISPLAY_USER_LINKS_PARAMETER = "displayUserLinks";
    private CurrentUserProvider _currentUserProvider;
    private DirectoryHelper _directoryHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._directoryHelper = (DirectoryHelper)((Object)serviceManager.lookup(DirectoryHelper.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String customThemeName;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Page page = (Page)request.getAttribute(Page.class.getName());
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(ZoneItem.class.getName());
        String siteName = (String)request.getAttribute("site");
        String language = (String)request.getAttribute("renderingLanguage");
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        String[] themes = (String[])serviceParameters.getValue("themes", false, (Object)new String[0]);
        this.contentHandler.startDocument();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("siteName", siteName);
        attrs.addCDATAAttribute("language", language);
        if (page != null) {
            attrs.addCDATAAttribute("page", page.getId());
        }
        UserIdentity user = this._currentUserProvider.getUser();
        List<DefaultLink> links = this._directoryHelper.getLinks(Arrays.asList(themes), siteName, language);
        String storageContext = null;
        attrs.addCDATAAttribute("zoneItemId", zoneItem.getId());
        if (user != null) {
            storageContext = this._directoryHelper.getStorageContext(request, zoneItem.getId());
        }
        String string = customThemeName = serviceParameters.hasValue("custom-theme") ? (String)serviceParameters.getValue("custom-theme") : null;
        if (this._directoryHelper.themeExists(customThemeName, siteName, language)) {
            attrs.addCDATAAttribute("custom-theme", customThemeName);
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"links", (Attributes)attrs);
        try {
            this._saxDeletedThemes(siteName, language, Arrays.asList(themes));
            List<DefaultLink> userLinks = null;
            if (user != null && ((Boolean)serviceParameters.getValue(__DISPLAY_USER_LINKS_PARAMETER, false, (Object)false)).booleanValue()) {
                userLinks = this._directoryHelper.getUserLinks(siteName, language, user, customThemeName).stream().collect(Collectors.toList());
            }
            boolean configurable = (Boolean)serviceParameters.getValue("configurable", false, (Object)false);
            this._directoryHelper.saxLinks(siteName, this.contentHandler, links, userLinks, Arrays.asList(themes), configurable, this._directoryHelper.getContextVars(request), storageContext, user);
        }
        catch (Exception e) {
            this.getLogger().error("An exception occurred while saxing the links", (Throwable)e);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"links");
        this.contentHandler.endDocument();
    }

    protected void _saxDeletedThemes(String siteName, String language, List<String> themesNamesList) throws SAXException {
        int amount = 0;
        for (String themeName : themesNamesList) {
            if (this._directoryHelper.themeExists(themeName, siteName, language)) continue;
            this.getLogger().warn("The id '" + themeName + "' does not reference an existing theme.");
            ++amount;
        }
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("count", Integer.toString(amount));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"unknown-themes", (Attributes)attr);
    }
}

