/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.theme;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProvider;
import org.ametys.cms.tag.jcr.AbstractJCRTagsDAO;
import org.ametys.cms.tag.jcr.JCRTag;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.linkdirectory.theme.JCRThemeProvider;
import org.ametys.plugins.linkdirectory.theme.ThemeJCR;
import org.ametys.plugins.linkdirectory.theme.ThemeProviderExtensionPoint;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang3.StringUtils;

public class JCRThemesDAO
extends AbstractJCRTagsDAO {
    public static final String ROLE = JCRThemesDAO.class.getName();
    protected ThemeProviderExtensionPoint _tagProviderExtPt;
    protected RightManager _rightManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._tagProviderExtPt = (ThemeProviderExtensionPoint)((Object)serviceManager.lookup(ThemeProviderExtensionPoint.ROLE));
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
    }

    public ModifiableTraversableAmetysObject _getTagRootObject(String tagProviderId, Map<String, Object> contextualParameters) throws RepositoryException {
        JCRThemeProvider provider = (JCRThemeProvider)((Object)this._tagProviderExtPt.getExtension(tagProviderId));
        return provider.getRootNode(contextualParameters);
    }

    protected void _checkUserRight() throws IllegalStateException {
        String rightId = "LinkDirectory_Rights_Themes_Handle";
        String context = "/cms";
        UserIdentity user = this._currentUserProvider.getUser();
        if (this._rightManager.hasRight(user, rightId, (Object)context) != RightManager.RightResult.RIGHT_ALLOW) {
            this.getLogger().error("User '" + String.valueOf(user) + "' tried to access a privileged feature without convenient right. Should have right '" + rightId + "' on context '" + context + "'");
            throw new IllegalStateException("You have no right to access this feature.");
        }
    }

    protected Tag _getTagFromName(String name, Map<String, Object> contextualParameters) {
        return this._tagProviderExtPt.getTag(name, contextualParameters);
    }

    protected JCRTag _createJCRTag(String parentId, String name, String title, String description, Map<String, Object> otherParameters, Map<String, Object> contextualParameters) throws RepositoryException {
        ModifiableTraversableAmetysObject parent = null;
        parent = StringUtils.isEmpty((CharSequence)parentId) ? this._getTagRootObject(JCRThemeProvider.class.getName(), contextualParameters) : (ModifiableTraversableAmetysObject)this._resolver.resolveById(parentId);
        if (parent.hasChild(name)) {
            throw new RepositoryException("This theme already exists.");
        }
        ThemeJCR jcrTag = (ThemeJCR)parent.createChild(name, "ametys:theme");
        jcrTag.setTitle(title);
        jcrTag.setDescription(description);
        parent.saveChanges();
        return jcrTag;
    }

    protected JCRTag _updateJCRTag(String tagId, String title, String description, Map<String, Object> otherParameters) throws UnknownAmetysObjectException {
        ThemeJCR jcrTag = (ThemeJCR)this._resolver.resolveById(tagId);
        jcrTag.setTitle(title);
        jcrTag.setDescription(description);
        jcrTag.saveChanges();
        return jcrTag;
    }

    protected Set<TagProvider<? extends Tag>> _getTagProviders() {
        HashSet<TagProvider<? extends Tag>> providers = new HashSet<TagProvider<? extends Tag>>();
        Set ids = this._tagProviderExtPt.getExtensionsIds();
        for (String id : ids) {
            TagProvider provider = (TagProvider)this._tagProviderExtPt.getExtension(id);
            providers.add((TagProvider<? extends Tag>)provider);
        }
        return providers;
    }

    @Callable(rights={"LinkDirectory_Rights_Themes_Handle"})
    public Map<String, Object> getTagRootNode(String tagProviderId, Map<String, Object> contextualParameters) throws ProcessingException {
        return super.getTagRootNode(tagProviderId, contextualParameters);
    }

    @Callable(rights={"LinkDirectory_Rights_Themes_Handle"})
    public Map<String, Object> getTag(String tagId) {
        return super.getTag(tagId);
    }
}

