<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common">
                
    <xsl:import href="service:link-directory://pages/services/directory/utils/config_utils.xsl"/>
    <xsl:import href="service:link-directory://pages/services/directory/utils/thumbnails_utils.xsl"/>
    
    <!-- Display the 'add user link' button if the inputdata also displays user links (favorites) -->
    <xsl:template name="display-add-user-link-btn-inputdata">
        <xsl:param name="customTheme" />
        <xsl:param name="displayUserLinks"/>
        <xsl:if test="$displayUserLinks = 'true'">
            <xsl:call-template name="add-user-link-btn-and-dialog">
                <xsl:with-param name="customTheme" select="$customTheme"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <!-- Display the configure links button if the inputdata is configurable -->
    <xsl:template name="display-configure-links-btn-inputdata">    
        <xsl:param name="maxCheckedLinks"/>
        <xsl:param name="inputDataId" select="''"/>
        
        <xsl:if test="/cms/inputData/linkDirectory[@id=$inputDataId]/@configurable = 'true'">
            <xsl:call-template name="configure-links-btn-and-dialog">
                <xsl:with-param name="links" select="/cms/inputData/linkDirectory[@id=$inputDataId]/links/link"/>
                <xsl:with-param name="maxCheckedLinks" select="$maxCheckedLinks"/>
                <xsl:with-param name="savingId" select="$inputDataId"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <!-- Input data configure links button : default rendering -->
    <xsl:template name="configure-links-btn">
        <xsl:param name="buttonId"/>
        
        <xsl:choose>
            <xsl:when test="not(ametys:user())">
                <!-- The user is not connected: the button is not displayed -->
            </xsl:when>
            <xsl:otherwise>
                document.writeln("&lt;p class=\"configure-links\"&gt;&lt;a id=\"configure-links-hyperlink-<xsl:value-of select="$buttonId"/>\" class=\"configure-links-inputdata-button\" href=\"javascript:void(0)\" title=\"<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_LINKS_TITLE" i18n:catalogue="plugin.link-directory"/>\" i18n:attr=\"title\"&gt;<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_LINKS" i18n:catalogue="plugin.link-directory"/>&lt;/a&gt;&lt;/p&gt;");
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="links-thumbnails-inputdata">
        <xsl:param name="moreThreshold"/>
        <xsl:param name="height"/>
        <xsl:param name="width"/>
        <xsl:param name="showThemes" select="'false'"/>
        <xsl:param name="showUrl" select="'false'"/>
        <xsl:param name="showTitle" select="'true'"/>
        <xsl:param name="uniqueId" select="$uniqueId" />
        <xsl:param name="inputDataId" select="''" />
        
        <xsl:call-template name="unknown-themes">
            <xsl:with-param name="count" select="/cms/inputData/linkDirectory[@id=$inputDataId]/unknown-themes/@count"/>
            <xsl:with-param name="data" select="/cms/inputData/linkDirectory[@id=$inputDataId]/unknown-themes"/>
            <xsl:with-param name="target" select="'inputdata'"/>
        </xsl:call-template>
    
        <xsl:call-template name="links-thumbnails">
            <xsl:with-param name="links" select="/cms/inputData/linkDirectory[@id=$inputDataId]/links/link"/>
            <xsl:with-param name="moreThreshold" select="$moreThreshold"/>
            <xsl:with-param name="height" select="$height"/>
            <xsl:with-param name="width" select="$width"/>
            <xsl:with-param name="themes" select="/cms/inputData/linkDirectory[@id=$inputDataId]/themes"/>
            <xsl:with-param name="showThemes" select="$showThemes"/>
            <xsl:with-param name="showUrl" select="$showUrl"/>
            <xsl:with-param name="showTitle" select="$showTitle"/>
            <xsl:with-param name="uniqueId" select="$uniqueId" />
        </xsl:call-template>
    </xsl:template>
    
    <!-- Template used when "link-themes.xml" is invalid -->    
    <xsl:template name="linkdirectory-configuration-error">    
        <xsl:if test="/cms/inputData/linkDirectory/@error">
	        <xsl:if test="$rendering-context = 'back'">
	            <div class="ametys-cms-zone ametys-cms-zone-error">
	                <img style="float: left" alt="" src="{$uri-prefix}/plugins/web/resources/img/skin/zone_error_32.png"/>
	                <strong><i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURATION_ERROR_TITLE" i18n:catalogue="plugin.link-directory"/></strong>
	                <br/>
	                <div class="ametys-cms-zone-error-desc">
	                    <i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURATION_ERROR_TEXT" i18n:catalogue="plugin.link-directory"/>
                        <xsl:for-each select="/cms/inputData/linkDirectory/@error">
                            <xsl:value-of select="."/>
                        </xsl:for-each>
                    </div>
	            </div>
	        </xsl:if>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
