/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Link directory context for profile assignments.
 */
Ext.define('Ametys.plugins.linkdirectory.LinkDirectoryRightAssignmentContext', {
    extend: 'Ametys.plugins.coreui.profiles.AbstractRightAssignmentContext',
    
    getComponent: function()
    {
    	this._grid = Ext.create('Ametys.plugins.linkdirectory.link.LinkDirectoryGrid', {
    		columns: [
                {stateId: 'grid-column-url', header: "{{i18n PLUGINS_LINKDIRECTORY_UITOOL_URL}}", width: 160, dataIndex: 'url', renderer: Ametys.plugins.linkdirectory.link.LinkDirectoryGrid.renderUrl},
                {stateId: 'grid-column-status', header: "{{i18n PLUGINS_LINKDIRECTORY_UITOOL_STATUS}}", width: 60, dataIndex: 'status', hidden: true, renderer: Ametys.plugins.linkdirectory.link.LinkDirectoryGrid.renderStatus},
                {stateId: 'grid-column-title', header: "{{i18n PLUGINS_LINKDIRECTORY_UITOOL_TITLE}}", width: 100, dataIndex: 'title', hidden: true},
                {stateId: 'grid-column-alternative', header: "{{i18n PLUGINS_LINKDIRECTORY_UITOOL_ALTERNATIVE}}", width: 100, dataIndex: 'alternative', hidden: true},
                {stateId: 'grid-column-themes', header: "{{i18n PLUGINS_LINKDIRECTORY_UITOOL_THEMES}}", width: 100, dataIndex: 'themes', renderer: Ametys.plugins.linkdirectory.link.LinkDirectoryGrid.renderThemes, hidden: true},
                {stateId: 'grid-column-restricted', header: "{{i18n PLUGINS_LINKDIRECTORY_UITOOL_LIMITED_ACCESS}}", width: 60, dataIndex: 'isRestricted', renderer: Ametys.plugins.linkdirectory.link.LinkDirectoryGrid.renderLimitedAccess, hidden: true}
            ]
    	});
    	this._grid.on('selectionchange', this._onSelectionChanged, this);
    	return this._grid;
    },
    
    initialize: function()
    {
    	// Reload grid
    	this._grid.getStore().load({
    		callback: function()
    		{
    			if (this._linkDirectoryIdToSelect != null)
    	    	{
    				this._grid.setSelection(this._grid.getStore().getById(this._linkDirectoryIdToSelect))
    	    	}
    		},
    		scope: this
		});
    },
    
    isSupported: function (message)
    {
    	return message.getTargets(Ametys.message.MessageTarget.LINK_DIRECTORY).length > 0;
    },
    
    initContext: function (message)
    {
    	this._linkDirectoryIdToSelect = null;
    	
    	var linkDirectoryTarget = message.getTarget(Ametys.message.MessageTarget.LINK_DIRECTORY);
    	if (linkDirectoryTarget != null)
    	{
    		this._linkDirectoryIdToSelect = linkDirectoryTarget.getParameters().id;
    	}
    },
    
    /**
     * @private
     * Listener when the selection in the grid has changed
     * @param {Ext.selection.Model} model The selection model
     * @param {Ext.data.Model[]} selected The selected records
     */
    _onSelectionChanged: function(model, selected)
    {
        if (selected.length > 0)
        {
    		var object = selected[0];
    		var hintTextContext ="{{i18n PLUGINS_LINKDIRECTORY_LINKDIRECTORYACCESS_CONTEXT_HINT_LINKDIRECTORY}} <b>" + selected[0].get('url') + "</b>";
            
            this._changeObjectContext(object.get('id'), hintTextContext, false);
        }
        else
        {
        	this._changeObjectContext(null);
        }
    }
});
