/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.linkdirectory.link;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.cocoon.JSonReader;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.plugins.linkdirectory.repository.DefaultLink;
import org.ametys.plugins.repository.AmetysObjectIterable;

/**
 * Get all links in JSON
 */
public class GetLinksAction extends ServiceableAction
{
    private LinkDAO _linkDAO;
    private DirectoryHelper _directoryHelper;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _linkDAO = (LinkDAO) smanager.lookup(LinkDAO.ROLE);
        _directoryHelper = (DirectoryHelper) smanager.lookup(DirectoryHelper.ROLE);
    }
    
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        Map<String, Object> result = new HashMap<> ();
        List<Map<String, Object>> links = new ArrayList<> ();
        
        String siteName = request.getParameter("siteName");
        String lang = request.getParameter("lang");
        
        AmetysObjectIterable<DefaultLink> defaultLinks = _directoryHelper.getLinks(siteName, lang);
        for (DefaultLink link : defaultLinks)
        {
            links.add(_linkDAO.convertLink2JsonObject(link));
        }
        
        result.put("links", links);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

}
