<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2017 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:exsl="http://exslt.org/common"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:variable name="refreshDelay" select="60000"/>
    <xsl:variable name="zoneItemId" select="ametys:zoneItemId()"/>
    
    <!--  The links in thumbnails mode -->
    <xsl:template name="links-thumbnails">
        <xsl:param name="links"/>
        <xsl:param name="cssClass">links</xsl:param>
        <xsl:param name="moreThreshold"/>
        <xsl:param name="height" select="96"/>
        <xsl:param name="width" select="96"/>
        <xsl:param name="themes"/>
        <xsl:param name="showThemes"/>
        <xsl:param name="showUrl"/>
        <xsl:param name="showTitle">true</xsl:param>
        <xsl:param name="uniqueId" select="$uniqueId" />
        
        <xsl:variable name="links-raw">
            <xsl:call-template name="separate-links">
                <xsl:with-param name="links" select="$links"/>
                <xsl:with-param name="moreThreshold" select="$moreThreshold"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="separated-links" select="exsl:node-set($links-raw)"/>
        
        <!-- The first $moreThreshold links -->
        <ul class="{$cssClass}">
            <xsl:apply-templates select="$separated-links/primary/link" mode="thumbnails">
                <xsl:with-param name="height" select="$height"/>
                <xsl:with-param name="width" select="$width"/>
                <xsl:with-param name="showThemes" select="$showThemes"/>
                <xsl:with-param name="showUrl" select="$showUrl"/>
                <xsl:with-param name="showTitle" select="$showTitle"/>
                <xsl:with-param name="uniqueId" select="$uniqueId"/>
            </xsl:apply-templates>     
            
            <xsl:if test="count($links) &gt; $moreThreshold">
                <xsl:call-template name="see-more-less">
                    <xsl:with-param name="height" select="$height"/>
                    <xsl:with-param name="width" select="$width"/>
                    <xsl:with-param name="buttonId" select="$uniqueId"/>
                </xsl:call-template>
            </xsl:if>
        </ul>
            
        <!-- The remaining links -->
        <xsl:if test="$separated-links/secondary">
            <ul class="{$cssClass}" id="secondary-links-{$uniqueId}">
	            <xsl:apply-templates select="$separated-links/secondary/link" mode="thumbnails">
	               <xsl:with-param name="height" select="$height"/>
                   <xsl:with-param name="width" select="$width"/>
                   <xsl:with-param name="showThemes" select="$showThemes"/>
                   <xsl:with-param name="showUrl" select="$showUrl"/>
                   <xsl:with-param name="showTitle" select="$showTitle"/>
                   <xsl:with-param name="uniqueId" select="$uniqueId"/>
                </xsl:apply-templates>
            </ul>
            <script type="text/javascript">
                $j("#secondary-links-<xsl:value-of select="$uniqueId"/>").hide();
            </script>      
        </xsl:if>
    </xsl:template>
    
    <!-- Separate the links in two groups for input data and service in thumbnails view -->
    <xsl:template name="separate-links">
        <xsl:param name="links"/>
        <xsl:param name="moreThreshold"/>
        
        <primary>
            <xsl:for-each select="$links">
                <xsl:sort select="@user-selected = 'true'" order="descending"/>
                
                <xsl:if test="position() &lt; $moreThreshold or (count($links) = $moreThreshold and position() = $moreThreshold)">
                    <xsl:copy-of select="."/>
                </xsl:if>
            </xsl:for-each>
        </primary>
        
        <xsl:if test="count($links) &gt; $moreThreshold">
	        <secondary>
	            <xsl:for-each select="$links">
	                <xsl:sort select="@user-selected = 'true'" order="descending"/>
	                
	                <xsl:choose>
	                    <xsl:when test="position() &gt;= $moreThreshold">
	                        <xsl:copy-of select="."/>
	                    </xsl:when>
	                </xsl:choose>
	            </xsl:for-each>
	        </secondary>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="link[@url != '' and @isHidden = 'false']" mode="thumbnails">
        <xsl:param name="height"/>
        <xsl:param name="width"/>
        <xsl:param name="showThemes"/>
        <xsl:param name="showUrl"/>
        <xsl:param name="showTitle">true</xsl:param>
        <xsl:param name="uniqueId" select="$uniqueId"/>
        
        <li>
        	<xsl:choose>
                <xsl:when test="@disabled">
                    <xsl:attribute name="class">link <xsl:call-template name="common-utils-class"/> link-disabled</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="class">link <xsl:call-template name="common-utils-class"/></xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="@urlType = 'PAGE'">
                    <a href="{resolver:resolve('page', @url)}">
                         <xsl:call-template name="link-status" />
                    
                         <xsl:call-template name="link-title">
                            <xsl:with-param name="showThemes" select="$showThemes"/>
                            <xsl:with-param name="showUrl" select="$showUrl"/>
                         </xsl:call-template>
                         <xsl:call-template name="link-picture">
                            <xsl:with-param name="height" select="$height"/>
                            <xsl:with-param name="width" select="$width"/>
                         </xsl:call-template>
                         <xsl:if test="$showTitle = 'true'">
                            <xsl:call-template name="link-text"/>
                         </xsl:if>
                       	 <xsl:call-template name="link-dynamic-info">
                       	    <xsl:with-param name="uniqueId" select="$uniqueId" />
                       	 </xsl:call-template>
                    </a>    
                </xsl:when>
                <xsl:otherwise>
                	<xsl:choose>
                    	<xsl:when test="@disabled">
                            <span>
		                         <xsl:call-template name="link-title">
		                            <xsl:with-param name="showThemes" select="$showThemes"/>
		                            <xsl:with-param name="showUrl" select="$showUrl"/>
		                         </xsl:call-template>
		                         <xsl:call-template name="link-picture">
		                            <xsl:with-param name="height" select="$height"/>
		                            <xsl:with-param name="width" select="$width"/>
		                         </xsl:call-template>
		                         <xsl:if test="$showTitle = 'true'">
		                            <xsl:call-template name="link-text"/>
		                         </xsl:if>
                            </span>
                        </xsl:when>
                        <xsl:otherwise>
                      		<a href="{@url}" onclick="window.open(this.href); return false;">
                      		     <xsl:call-template name="link-status" />
                      		
		                         <xsl:call-template name="link-title">
		                            <xsl:with-param name="showThemes" select="$showThemes"/>
		                            <xsl:with-param name="showUrl" select="$showUrl"/>
		                         </xsl:call-template>
		                         <xsl:call-template name="link-picture">
		                            <xsl:with-param name="height" select="$height"/>
		                            <xsl:with-param name="width" select="$width"/>
		                         </xsl:call-template>
		                         <xsl:if test="$showTitle = 'true'">
		                            <xsl:call-template name="link-text"/>
		                         </xsl:if>
	                         	 <xsl:call-template name="link-dynamic-info">
		                            <xsl:with-param name="uniqueId" select="$uniqueId" />
		                         </xsl:call-template>
		                    </a>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
    
    <xsl:template name="link-title">
        <xsl:param name="showThemes"/>
        <xsl:param name="showUrl"/>
        
        <xsl:attribute name="title">
           <xsl:choose>
               <xsl:when test="normalize-space(@alternative) != ''">
                   <xsl:value-of select="@alternative"/>
               </xsl:when>
               <xsl:when test="normalize-space(@pageTitle) != ''">
                   <xsl:value-of select="@pageTitle"/>
               </xsl:when>
               <xsl:otherwise>
                   <xsl:value-of select="@url"/>
               </xsl:otherwise>
           </xsl:choose>
           <xsl:if test="$showThemes = 'true'">
                <xsl:for-each select="themes/theme">
                    <xsl:if test="position() = 1">
                         <xsl:text> - </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="@label"/>
                    <xsl:if test="position() != last()">
                         <xsl:text>, </xsl:text>
                    </xsl:if>
                </xsl:for-each>
           </xsl:if>
           <xsl:if test="$showUrl = 'true'">
               <xsl:text> (</xsl:text><xsl:value-of select="@url"/><xsl:text>)</xsl:text>
           </xsl:if>
        </xsl:attribute>
    </xsl:template>
    
    <xsl:template name="link-picture">
        <xsl:param name="height"/>
        <xsl:param name="width"/>
        
        <xsl:if test="@pictureType != ''">
        	<xsl:choose>
        		<xsl:when test="@pictureType = 'glyph'">
        			<span class="picture link-glyph {@pictureGlyph}" style="font-size: {$height}px; color:{@color}"></span>
        		</xsl:when>
        		<xsl:otherwise>
        			<xsl:variable name="id">
		                <xsl:choose>
		                    <xsl:when test="@pictureType = 'resource'">
		                        <xsl:value-of select="@pictureId"/>
		                    </xsl:when>
		                    <xsl:when test="@pictureType = 'external'">
		                        <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
		                    </xsl:when>
		                </xsl:choose>
		            </xsl:variable>
            
		            <span class="picture">
		                <img src="{resolver:resolveBoundedImage(@imageType, $id, $height, $width)}" alt="{@pictureAlternative}"/>
		            </span>
        		</xsl:otherwise>
        	</xsl:choose>
         </xsl:if>
    </xsl:template>

    <xsl:template name="link-dynamic-info">
        <xsl:param name="uniqueId" select="$uniqueId" />
    	<span class="link-dynamic-info" id="{concat('link-info-', $uniqueId, '-', substring-after(@id, 'directoryLink://'))}"></span>
    </xsl:template>
                
    <xsl:template name="link-text">
        <span>
            <xsl:attribute name="class">text <xsl:if test="@pictureType = ''">nopicture</xsl:if></xsl:attribute>
        
             <xsl:choose>
                 <xsl:when test="@title != ''"> 
                        <xsl:value-of select="@title"/>
                 </xsl:when>
                  <xsl:when test="@pageTitle != ''"> 
                        <xsl:value-of select="@pageTitle"/>
                 </xsl:when>
                 <xsl:otherwise>
                        <xsl:value-of select="@url"/>
                 </xsl:otherwise>
             </xsl:choose>
        </span>
    </xsl:template>
    
    <xsl:template name="dynamic-info-view">default</xsl:template>
    
    <xsl:template name="link-dynamic-info-js">
    	<xsl:param name="maxItems">5</xsl:param>
    	<xsl:param name="themes"/>
		<xsl:param name="uniqueId" select="$uniqueId"/>
		
	    <xsl:if test="count(//link[@dynamicInformationProvider and @dynamicInformationProvider != '']) > 0">
			<script type="text/javascript">
	    		function updateDynamicInformation_<xsl:value-of select="$uniqueId"/>() {
                   var themes = [];
	    			
	    			<xsl:if test="$themes != ''">
		    			<xsl:for-each select="$themes/*">
			        		themes.push('<xsl:value-of select="."/>');
			       		</xsl:for-each>
			       	</xsl:if>

		    		$j.ajax({
		    			url: '<xsl:value-of select="$site-uri-prefix"/>/_plugins/link-directory/dynamic-information/update/<xsl:value-of select="$site"/>/<xsl:call-template name="dynamic-info-view"/>',
		    			type: 'POST',
		    			dataType: 'xml',
		    			data: {
		    				site: '<xsl:value-of select="$site"/>',
		    				lang: '<xsl:value-of select="$lang"/>',
		    				themes: themes.length > 0 ? themes.join(",") : null,
		    				maxItems: '<xsl:value-of select="$maxItems"/>',
                            uniqueId: '<xsl:value-of select="$uniqueId"/>'
		    			},
		    			success: function(data) {
		    				$j(data).find('> dynamic-information > dynamic-information').each(function(){
		    					var linkId = $j(this).attr('id');
                                var hasError = $j(this).attr('error') !== undefined;
		    					var spanId = 'link-info-<xsl:value-of select="$uniqueId"/>-' + linkId.substring('directoryLink://'.length);
                                var parentLink = $j('#' + spanId).closest("a");
                                
                                // remove old error if exists
                                parentLink.parent().find('.link-info-error-message').remove();
                                    
                                if (hasError)
                                {
                                    // Insert error after link
                                    parentLink.after(this.innerHTML);
                                    parentLink.addClass("error");
                                    $j('#' + spanId).html("");
                                }
                                else
                                {
                                    $j('#' + spanId).html(this.innerHTML);
                                    parentLink.removeClass("error");
                                }
		                    });
		    			},
		    			error: function(result, status, error) {
		    				console.log(error);
		    			},
		    			complete: function() {
		    				setTimeout(updateDynamicInformation_<xsl:value-of select="$uniqueId"/>, <xsl:value-of select="$refreshDelay"/>);
		    			}
		    		});
	    		}
	            
	            $j(document).ready(updateDynamicInformation_<xsl:value-of select="$uniqueId"/>);
	   		</script>
   		</xsl:if>
   	</xsl:template>
   	
    <!-- The see more/less links functionality -->
    <xsl:template name="see-more-less">
        <xsl:param name="height"/>
        <xsl:param name="width"/>
        <xsl:param name="buttonId"/>
        
        <script type="text/javascript">
            
            document.write("&lt;li id=\"show-more-links-<xsl:value-of select="$buttonId"/>\" class=\"link\" &gt;&lt;a href=\"javascript:showSecondaryLinks<xsl:value-of select="$buttonId"/>()\" title=\"<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_SEE_MORE" i18n:catalogue="plugin.link-directory"/>\"&gt;");
            <xsl:call-template name="show-more-picture">
                <xsl:with-param name="height" select="$height"/>
                <xsl:with-param name="width" select="$width"/>
            </xsl:call-template>
            document.write("&lt;/a&gt;&lt;/li&gt;");
            
            document.write("&lt;li id=\"show-less-links-<xsl:value-of select="$buttonId"/>\" class=\"link\" &gt;&lt;a href=\"javascript:hideSecondaryLinks<xsl:value-of select="$buttonId"/>()\" title=\"<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_SEE_LESS" i18n:catalogue="plugin.link-directory"/>\"&gt;");
            <xsl:call-template name="show-less-picture">
                <xsl:with-param name="height" select="$height"/>
                <xsl:with-param name="width" select="$width"/>
            </xsl:call-template>
            document.write("&lt;/a&gt;&lt;/li&gt;");
            
            function showSecondaryLinks<xsl:value-of select="$buttonId"/>()
            {
                $j("#show-more-links-<xsl:value-of select="$buttonId"/>").hide();
                $j("#show-less-links-<xsl:value-of select="$buttonId"/>").show();
                $j("#secondary-links-<xsl:value-of select="$buttonId"/>").show();
            }
            
            function hideSecondaryLinks<xsl:value-of select="$buttonId"/>()
            {
                $j("#show-more-links-<xsl:value-of select="$buttonId"/>").show();
                $j("#show-less-links-<xsl:value-of select="$buttonId"/>").hide();
                $j("#secondary-links-<xsl:value-of select="$buttonId"/>").hide();
            }
    
            $j("#show-less-links-<xsl:value-of select="$buttonId"/>").hide();
        </script>
    </xsl:template>
   
    <xsl:template name="show-less-picture">
        document.write("&lt;span class=\"picture\"&gt;<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_LESS" i18n:catalogue="plugin.link-directory"/>&lt;/span&gt;");
    </xsl:template>
   
    <xsl:template name="show-more-picture">
        document.write("&lt;span class=\"picture\"&gt;<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_MORE" i18n:catalogue="plugin.link-directory"/>&lt;/span&gt;");
    </xsl:template>
    
    <xsl:template name="link-status">
        <xsl:choose>
            <xsl:when test="@status = 'BROKEN'">
                <xsl:attribute name="class">broken</xsl:attribute>
            </xsl:when>
            <xsl:when test="@status = 'NEW'">
                <xsl:attribute name="class">new</xsl:attribute>
                <xsl:attribute name="data-new-message">PLUGINS_LINKDIRECTORY_NEW_MESSAGE</xsl:attribute>
                <xsl:attribute name="i18n:attr">data-new-message</xsl:attribute>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
    