/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.linkdirectory;

/**
 * Events relative to link directory.
 */
public interface DirectoryEvents
{
    
    /** Fired when a link is created. */
    public static final String LINK_CREATED = "link.created";
    
    /** Fired when a link is modified. */
    public static final String LINK_MODIFIED = "link.modified";
    
    /** Fired when a link is deleted. */
    public static final String LINK_DELETED = "link.deleted";
    
    /** Fired when a link theme is created. */
    public static final String THEME_CREATED = "theme.created";
    
    /** Fired when a link theme is modified. */
    public static final String THEME_MODIFIED = "theme.modified";
    
    /** Fired when a link theme is deleted. */
    public static final String THEME_DELETED = "theme.deleted";
    
}
