/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.linkdirectory.right;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.right.AbstractStaticRightAssignmentContext;
import org.ametys.core.right.RightAssignmentContext;
import org.ametys.plugins.linkdirectory.Link;
import org.ametys.plugins.linkdirectory.link.LinkDAO;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * {@link RightAssignmentContext} for assign rights to a {@link Link}
 */
public class LinkDirectoryRightAssignmentContext extends AbstractStaticRightAssignmentContext
{
    /** The id if this right context */
    public static final String ID = "right.assignment.context.linkdirectoryaccess";
    
    /** The Ametys object resolver */
    protected AmetysObjectResolver _resolver;
    /** the link DAO */
    protected LinkDAO _linkDAO;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _linkDAO = (LinkDAO) smanager.lookup(LinkDAO.ROLE);
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
    }
    
    @Override
    public Object convertJSContext(Object context)
    {
        if (context instanceof String)
        {
            return _resolver.resolveById((String) context);
        }
        return null;
    }
    
    @Override
    public String getContextIdentifier(Object context)
    {
        if (context instanceof Link)
        {
            return ((Link) context).getTitle();
        }
        return null;
    }
    
    @Override
    public Set<Object> getParentContexts(Object context)
    {
        return null;
    }
    
    @Override
    public List<Object> getRootContexts(Map<String, Object> contextParameters)
    {
        return new ArrayList<>();
    }
}
