/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class LinkDirectorySetUserPreferencesAction
extends ServiceableAction {
    private UserPreferencesManager _userPrefManager;
    private CurrentUserProvider _currentUserProvider;
    private DirectoryHelper _directoryHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userPrefManager = (UserPreferencesManager)serviceManager.lookup(UserPreferencesManager.ROLE + ".FO");
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._directoryHelper = (DirectoryHelper)((Object)serviceManager.lookup(DirectoryHelper.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap result = new HashMap();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        UserIdentity user = this._currentUserProvider.getUser();
        if (user != null && StringUtils.isNotEmpty((CharSequence)user.getLogin()) && StringUtils.isNotEmpty((CharSequence)user.getPopulationId())) {
            String zoneItemId = request.getParameter("saving-id");
            String storageContext = this._directoryHelper.getStorageContext(request, zoneItemId);
            Map<String, String> contextVars = this._directoryHelper.getContextVars(request);
            this._setLinksPositionUserPref(request, storageContext, contextVars, user);
            this._setHiddenLinksUserPref(request, storageContext, contextVars, user);
            request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        }
        return EMPTY_MAP;
    }

    private void _setLinksPositionUserPref(Request request, String storageContext, Map<String, String> contextVars, UserIdentity user) throws UserPreferencesException {
        String linksPosition = this._getLinksPosition(request);
        if (linksPosition != null) {
            this._userPrefManager.addUserPreference(user, storageContext, contextVars, "checked-links", linksPosition);
        }
    }

    private String _getLinksPosition(Request request) {
        return request.getParameter("ordered-links");
    }

    private void _setHiddenLinksUserPref(Request request, String storageContext, Map<String, String> contextVars, UserIdentity user) throws UserPreferencesException {
        String hiddenLinks = this._getHiddenLinks(request);
        if (hiddenLinks != null) {
            this._userPrefManager.addUserPreference(user, storageContext, contextVars, "hidden-links", hiddenLinks);
        }
    }

    private String _getHiddenLinks(Request request) {
        return request.getParameter("hidden-links");
    }
}

