/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.repository;

import org.ametys.cms.repository.Content;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.actions.ExplorerResourcesDAO;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.plugins.linkdirectory.Link;
import org.ametys.plugins.linkdirectory.repository.DefaultLink;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.site.CopyUpdater;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class LinksCopyUpdater
extends AbstractLogEnabled
implements CopyUpdater,
Serviceable {
    protected AmetysObjectResolver _resolver;
    protected DirectoryHelper _directoryHelper;
    protected ExplorerResourcesDAO _explorerDAO;

    public void service(ServiceManager manager) throws ServiceException {
        this._directoryHelper = (DirectoryHelper)((Object)manager.lookup(DirectoryHelper.ROLE));
        this._explorerDAO = (ExplorerResourcesDAO)manager.lookup(ExplorerResourcesDAO.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void updateSite(Site initialSite, Site createdSite) {
        try (AmetysObjectIterable sitemaps = createdSite.getSitemaps();){
            for (Sitemap sitemap : sitemaps) {
                String allLinksQuery = this._directoryHelper.getAllLinksQuery(createdSite.getName(), sitemap.getName());
                AmetysObjectIterable links = this._resolver.query(allLinksQuery);
                try {
                    for (DefaultLink link : links) {
                        if (link.getUrlType() == Link.LinkType.PAGE) {
                            link.setUrl(Link.LinkType.PAGE, this._getPage(link.getUrl(), initialSite, createdSite));
                        }
                        String pageId = link.getPage();
                        if (StringUtils.isNotBlank((CharSequence)link.getPage())) {
                            link.setPage(this._getPage(pageId, initialSite, createdSite));
                        }
                        if (!"resource".equals(link.getPictureType())) continue;
                        link.setResourcePicture(this._getResource(link.getResourcePictureId(), initialSite, createdSite));
                    }
                }
                finally {
                    if (links == null) continue;
                    links.close();
                }
            }
        }
        if (createdSite.needsSave()) {
            createdSite.saveChanges();
        }
    }

    protected String _getPage(String initialPageId, Site initialSite, Site createdSite) {
        try {
            Page initialPage = (Page)this._resolver.resolveById(initialPageId);
            if (initialPage.getSite().equals((Object)initialSite)) {
                Sitemap createdSitemap = createdSite.getSitemap(initialPage.getSitemapName());
                Page createdPage = (Page)createdSitemap.getChild(initialPage.getPathInSitemap());
                return createdPage.getId();
            }
            return initialPageId;
        }
        catch (AmetysRepositoryException e) {
            this.getLogger().error("Failed to migrate link to page '{}' from  site '{}' to site '{}'", new Object[]{initialPageId, initialSite.getName(), createdSite.getName(), e});
            return initialPageId;
        }
    }

    protected String _getResource(String initialResourceId, Site initialSite, Site createdSite) {
        try {
            Resource initialResource = (Resource)this._resolver.resolveById(initialResourceId);
            if (initialResource.getPath().startsWith(initialSite.getRootResources().getPath())) {
                Resource newResource = (Resource)createdSite.getRootResources().getChild(initialResource.getResourcePath().substring(1));
                return newResource.getId();
            }
            return initialResourceId;
        }
        catch (AmetysRepositoryException e) {
            this.getLogger().error("Failed to migrate link picture '{}' from  site '{}' to site '{}'", new Object[]{initialResourceId, initialSite.getName(), createdSite.getName(), e});
            return initialResourceId;
        }
    }

    public void updatePage(Site initialSite, Site createdSite, Page page) {
    }

    public void updateContent(Site initialSite, Site createdSite, Content initialContent, Content createdContent) {
    }
}

