/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.dynamic;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.plugins.linkdirectory.Link;
import org.ametys.plugins.linkdirectory.dynamic.DynamicInformationProvider;
import org.ametys.plugins.linkdirectory.dynamic.DynamicInformationProviderExtensionPoint;
import org.ametys.plugins.linkdirectory.repository.DefaultLink;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DynamicInformationGenerator
extends ServiceableGenerator {
    private DirectoryHelper _directoryHelper;
    private DynamicInformationProviderExtensionPoint _dynamicInfoExtensionPoint;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._directoryHelper = (DirectoryHelper)((Object)serviceManager.lookup(DirectoryHelper.ROLE));
        this._dynamicInfoExtensionPoint = (DynamicInformationProviderExtensionPoint)((Object)serviceManager.lookup(DynamicInformationProviderExtensionPoint.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        int maxItems = Integer.valueOf(request.getParameter("maxItems"));
        String[] themeIds = request.getParameter("themes") != null ? request.getParameter("themes").split(",") : new String[]{};
        String siteName = request.getParameter("site");
        String lang = request.getParameter("lang");
        List<DefaultLink> links = this._directoryHelper.getLinks(Arrays.asList(themeIds), siteName, lang);
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"dynamic-information");
        for (DefaultLink defaultLink : links) {
            DynamicInformationProvider provider;
            String extensionId;
            if (defaultLink.getStatus() == Link.LinkStatus.BROKEN || !StringUtils.isNotBlank((CharSequence)(extensionId = defaultLink.getDynamicInformationProvider())) || (provider = (DynamicInformationProvider)this._dynamicInfoExtensionPoint.getExtension(extensionId)) == null) continue;
            String linkId = defaultLink.getId();
            try {
                provider.saxDynamicInformation(this.contentHandler, linkId, siteName, lang, maxItems);
            }
            catch (Exception e) {
                this.getLogger().error("Unable to sax dynamic information from provider of id '" + provider.getId() + "'", (Throwable)e);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"dynamic-information");
        this.contentHandler.endDocument();
    }
}

