/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.tracking;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ametys.cms.tag.Tag;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.linkdirectory.LinkDirectoryThemesInputDataHelper;
import org.ametys.plugins.linkdirectory.theme.ThemesDAO;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.webanalytics.matomo.tracking.AbstractMatomoEventTrackingProvider;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class LinkDirectoryMatomoTrackingProvider
extends AbstractMatomoEventTrackingProvider
implements Serviceable {
    protected UserPreferencesManager _userPreferencesManager;
    protected LinkDirectoryThemesInputDataHelper _linkDirectoryThemesInputDataHelper;
    protected ThemesDAO _themesDAO;
    protected I18nUtils _i18nUtils;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPreferencesManager = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE + ".FO");
        this._linkDirectoryThemesInputDataHelper = (LinkDirectoryThemesInputDataHelper)((Object)manager.lookup(LinkDirectoryThemesInputDataHelper.ROLE));
        this._themesDAO = (ThemesDAO)((Object)manager.lookup(ThemesDAO.ROLE));
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    protected List<AbstractMatomoEventTrackingProvider.MatomoEvent> getEvents(Site site) {
        ArrayList<AbstractMatomoEventTrackingProvider.MatomoEvent> requests = new ArrayList<AbstractMatomoEventTrackingProvider.MatomoEvent>();
        AmetysObjectIterable sitemaps = site.getSitemaps();
        for (Sitemap sitemap : sitemaps) {
            requests.addAll(this._getConfigurableLinkServiceEvents(site, sitemap));
            requests.addAll(this._getConfigurableLinkInputDataEvents(site, sitemap));
        }
        return requests;
    }

    private List<AbstractMatomoEventTrackingProvider.MatomoEvent> _getConfigurableLinkServiceEvents(Site site, Sitemap sitemap) {
        ArrayList<AbstractMatomoEventTrackingProvider.MatomoEvent> requests = new ArrayList<AbstractMatomoEventTrackingProvider.MatomoEvent>();
        String siteName = site.getName();
        String language = sitemap.getSitemapName();
        for (ModifiableZoneItem zoneItem : this._getLinkDirectoryServiceZoneItems(siteName)) {
            String[] themeIds;
            ModifiableModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
            for (String themeId : themeIds = (String[])serviceParameters.getValue("themes")) {
                try {
                    String themeLabel = this._getThemeLabel(themeId, siteName, language);
                    if (!StringUtils.isNotBlank((CharSequence)themeLabel)) continue;
                    requests.add(new AbstractMatomoEventTrackingProvider.MatomoEvent(language + "/" + themeLabel, (double)this._getNbUsersWithCustomLinks(siteName, language, zoneItem.getId())));
                }
                catch (UserPreferencesException e) {
                    this.getLogger().error("An error occurred getting user preferences for link directories. No request is sent to Matomo.", (Throwable)e);
                }
            }
        }
        return requests;
    }

    private AmetysObjectIterable<ModifiableZoneItem> _getLinkDirectoryServiceZoneItems(String siteName) {
        String xpathQuery = "//element(" + siteName + ", ametys:site)//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.plugins.linkdirectory.DirectoryService' and ametys:service_parameters/@ametys:configurable = 'true']";
        return this._resolver.query(xpathQuery);
    }

    private List<AbstractMatomoEventTrackingProvider.MatomoEvent> _getConfigurableLinkInputDataEvents(Site site, Sitemap sitemap) {
        ArrayList<AbstractMatomoEventTrackingProvider.MatomoEvent> requests = new ArrayList<AbstractMatomoEventTrackingProvider.MatomoEvent>();
        String siteName = site.getName();
        String language = sitemap.getSitemapName();
        LinkDirectoryThemesInputDataHelper.ConfiguredThemesInputData configuredThemes = this._linkDirectoryThemesInputDataHelper.getThemesInputData(site.getSkinId());
        String error = configuredThemes.error();
        if (StringUtils.isBlank((CharSequence)error) && configuredThemes.themesInputDatas() != null) {
            for (LinkDirectoryThemesInputDataHelper.ThemesInputData themesInputData : configuredThemes.themesInputDatas()) {
                try {
                    String themeId;
                    String themeLabel;
                    if (!themesInputData.configurable() || !StringUtils.isNotBlank((CharSequence)(themeLabel = this._getThemeLabel(themeId = (String)themesInputData.themes().stream().filter(t -> t.get("lang") == null || ((String)t.get("lang")).equals(language)).map(t -> (String)t.get("id")).findFirst().orElse(null), siteName, language)))) continue;
                    requests.add(new AbstractMatomoEventTrackingProvider.MatomoEvent(language + "/" + themeLabel, (double)this._getNbUsersWithCustomLinks(siteName, language, themesInputData.id())));
                }
                catch (UserPreferencesException e) {
                    this.getLogger().error("An error occurred getting user preferences for link directories. No request is sent to Matomo.", (Throwable)e);
                }
            }
        }
        return requests;
    }

    private String _getThemeLabel(String themeId, String siteName, String language) {
        Tag theme = StringUtils.isNotBlank((CharSequence)themeId) ? this._themesDAO.getTag(themeId, Map.of("language", language, "siteName", siteName)) : null;
        return theme != null ? this._i18nUtils.translate((I18nizable)theme.getTitle(), language) : null;
    }

    private long _getNbUsersWithCustomLinks(String siteName, String language, String thematicId) throws UserPreferencesException {
        String storageContext = siteName + "/" + language + "/" + thematicId;
        Map<String, String> contextVars = Map.of("siteName", siteName, "sitemapLanguage", language);
        return this._userPreferencesManager.getAllUnTypedUserPrefs(storageContext, contextVars).values().stream().filter(this::_hasCustomLinks).count();
    }

    private boolean _hasCustomLinks(Map<String, String> userPrefs) {
        String orderedLinksAsString = userPrefs.get("checked-links");
        String[] orderedLinks = StringUtils.split((String)orderedLinksAsString, (String)",");
        String hiddenLinksAsString = userPrefs.get("hidden-links");
        String[] hiddenLinks = StringUtils.split((String)hiddenLinksAsString, (String)",");
        return orderedLinks != null && orderedLinks.length > 0 || hiddenLinks != null && hiddenLinks.length > 0;
    }
}

