<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exslt="http://exslt.org/common" 
                xmlns:math="http://exslt.org/math">
      
    <xsl:param name="maxItems"/>
      
    <xsl:variable name="randomCount" select="number(substring-before(math:random() * 20, '.')) - 2"/>
    
    <xsl:template match="/">
    
        <xsl:variable name="items">
            <xsl:call-template name="get-items"/>
        </xsl:variable>
        
        <xsl:variable name="max">
            <xsl:choose>
                <xsl:when test="$randomCount &lt; $maxItems"><xsl:value-of select="$randomCount"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$maxItems"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <dynamic-information>
            <xsl:choose>
                <xsl:when test="$randomCount &lt; 0">
                    <error><i18n:text i18n:key="PLUGINS_LINKDIRECTORY_PROVIDER_FOR_TEST_ERROR" i18n:catalogue="plugin.link-directory"/></error>
                </xsl:when>
                <xsl:otherwise>
                    <short-value><xsl:value-of select="$randomCount"/></short-value>
                    <long-value>
                        <i18n:translate>
                            <i18n:text i18n:key="PLUGINS_LINKDIRECTORY_PROVIDER_FOR_TEST_TITLE" i18n:catalogue="plugin.link-directory"/>
                            <i18n:param><xsl:value-of select="$randomCount"/></i18n:param>
                        </i18n:translate>
                    </long-value>
                    <tooltip>
                        <xsl:for-each select="exslt:node-set($items)/item[position() &lt;= $max]">
                            <xsl:copy-of select="."/>
                        </xsl:for-each>
                    </tooltip>
                </xsl:otherwise>
            </xsl:choose>
        </dynamic-information>
    </xsl:template>
    
    <xsl:template name="get-items">
        <item>
            <title>Lorem ipsum sit amet</title>
            <summary>Quod idem cum vestri faciant, non satis magnam tribuunt inventoribus gratiam.</summary>
            <footer></footer>
        </item>
        <item>
            <title>Tum Quintus</title>
            <summary>An me, inquam, nisi te audire vellem, censes haec dicturum fuisse</summary>
            <footer>Compensabatur, inquit, cum summis</footer>
        </item>
        <item>
            <title>Eademne, quae restincta siti</title>
            <summary>Vide, ne etiam menses! nisi forte eum dicis, qui, simul atque arripuit, interficit</summary>
            <footer></footer>
        </item>
        <item>
            <title>Non est igitur summum malum dolor</title>
            <summary>Tu autem negas fortem esse quemquam posse, qui dolorem malum putet. Nunc haec primum fortasse audientis servire debemus.</summary>
            <footer>Tsi longus, levis</footer>
        </item>
        <item>
            <title>Lorem ipsum sit amet</title>
            <summary>Quod idem cum vestri faciant, non satis magnam tribuunt inventoribus gratiam.</summary>
            <footer></footer>
        </item>
        <item>
            <title>Tum Quintus</title>
            <summary>An me, inquam, nisi te audire vellem, censes haec dicturum fuisse</summary>
            <footer>Compensabatur, inquit, cum summis</footer>
        </item>
        <item>
            <title>Eademne, quae restincta siti</title>
            <summary>Vide, ne etiam menses! nisi forte eum dicis, qui, simul atque arripuit, interficit</summary>
            <footer></footer>
        </item>
        <item>
            <title>Non est igitur summum malum dolor</title>
            <summary>Tu autem negas fortem esse quemquam posse, qui dolorem malum putet. Nunc haec primum fortasse audientis servire debemus.</summary>
            <footer>Tsi longus, levis</footer>
        </item>
        <item>
            <title>Lorem ipsum sit amet</title>
            <summary>Quod idem cum vestri faciant, non satis magnam tribuunt inventoribus gratiam.</summary>
            <footer></footer>
        </item>
        <item>
            <title>Tum Quintus</title>
            <summary>An me, inquam, nisi te audire vellem, censes haec dicturum fuisse</summary>
            <footer>Compensabatur, inquit, cum summis</footer>
        </item>
        <item>
            <title>Eademne, quae restincta siti</title>
            <summary>Vide, ne etiam menses! nisi forte eum dicis, qui, simul atque arripuit, interficit</summary>
            <footer></footer>
        </item>
        <item>
            <title>Non est igitur summum malum dolor</title>
            <summary>Tu autem negas fortem esse quemquam posse, qui dolorem malum putet. Nunc haec primum fortasse audientis servire debemus.</summary>
            <footer>Tsi longus, levis</footer>
        </item>
    </xsl:template>
</xsl:stylesheet>