/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.linkdirectory;

import java.util.Arrays;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;

/**
 *  Service for the link directory : not cacheable when dealing with links that have a limited access or internal url
 */
public class LinkDirectoryService extends org.ametys.web.service.StaticService
{
    /** Name of service's parameter holding the display user links option */
    public static final String DISPLAY_USER_LINKS_PARAMETER = "displayUserLinks";
    /** Name of service's parameter holding the configurable option */
    public static final String CONFIGURABLE_LINKS_PARAMETER = "configurable";
    
    private DirectoryHelper _directoryHelper;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _directoryHelper = (DirectoryHelper) smanager.lookup(DirectoryHelper.ROLE);
    }
    
    @Override
    public boolean isCacheable(Page currentPage, ZoneItem zoneItem)
    {
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        boolean configurable = serviceParameters.getValue(CONFIGURABLE_LINKS_PARAMETER, false, false);
        boolean displayUserLinks = serviceParameters.getValue(DISPLAY_USER_LINKS_PARAMETER, false, false);
        
        if (configurable || displayUserLinks)
        {
            return false;
        }
        
        if (currentPage != null)
        {
            // Get the selected themes ids from the service parameters
            String[] themes = serviceParameters.hasValue("themes") ? serviceParameters.getValue("themes") : new String[0];
            
            // Get the site name and the language from the page
            String siteName = currentPage.getSiteName();
            String language = currentPage.getSitemapName();
            
            return !_directoryHelper.hasRestrictions(siteName, language, Arrays.asList(themes)) && !_directoryHelper.hasInternalUrl(siteName, language, Arrays.asList(themes));
        }

        // Current page is null
        return true;
    }
}
