/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.linkdirectory.dynamic;

import org.apache.avalon.framework.component.Component;
import org.xml.sax.ContentHandler;

import org.ametys.runtime.i18n.I18nizableText;

/**
 * Interface representing a provider of dynamic information
 */
public interface DynamicInformationProvider extends Component
{

    /**
     * SAX the dynamic information for a specific link
     * @param contentHandler The contenthandler to sax into
     * @param linkId The id of link.
     * @param siteName The current site name
     * @param language The language used.
     * @param nbItems The number of item to get for tooltip.
     * @throws Exception if an exception error occurs.
     */
    public void saxDynamicInformation(ContentHandler contentHandler, String linkId, String siteName, String language, int nbItems) throws Exception;

    /**
     * Get id of this provider
     * @return The id of this provider
     */
    public String getId();

    /**
     * Get label of this provider
     * @return The label of this provider
     */
    public I18nizableText getLabel();

}
