/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.theme;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.tag.AbstractTagProvider;
import org.ametys.cms.tag.DefaultTag;
import org.ametys.cms.tag.Tag;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class SkinThemeProvider
extends AbstractTagProvider<DefaultTag>
implements Serviceable {
    protected SourceResolver _resolver;
    protected Map<String, List<String>> _skinLocalIds;
    protected Map<String, Map<String, DefaultTag>> _skinTags;
    private SiteManager _siteManager;
    private SkinsManager _skinsManager;
    private DirectoryHelper _directoryHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._skinsManager = (SkinsManager)smanager.lookup(SkinsManager.ROLE);
        this._directoryHelper = (DirectoryHelper)((Object)smanager.lookup(DirectoryHelper.ROLE));
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._skinLocalIds = new HashMap<String, List<String>>();
        this._id = configuration.getAttribute("id");
        this._label = this.configureLabel(configuration, "plugin." + this._pluginName);
        this._description = this.configureDescription(configuration, "plugin." + this._pluginName);
        if (this._skinTags == null) {
            this._skinTags = new HashMap<String, Map<String, DefaultTag>>();
        }
        for (String skinName : this._skinsManager.getSkins()) {
            try {
                this.initializeTags(skinName);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to load tags configuration values for skin " + skinName, (Throwable)e);
            }
        }
    }

    public boolean hasTag(String tagID, Map<String, Object> contextualParameters) {
        return this.getTag(tagID, contextualParameters) != null;
    }

    public DefaultTag getTag(String tagID, Map<String, Object> contextualParameters) {
        Map<String, DefaultTag> tags = this.getTags(contextualParameters);
        return tags != null ? this._recursiveSearchTags(tags, tagID) : null;
    }

    public Collection<DefaultTag> getTags(String tagID, Map<String, Object> contextualParameters) {
        DefaultTag tag = this.getTag(tagID, contextualParameters);
        return tag != null ? tag.getTags().values() : null;
    }

    private DefaultTag _recursiveSearchTags(Map<String, DefaultTag> tags, String tagID) {
        if (tags.containsKey(tagID)) {
            return tags.get(tagID);
        }
        for (DefaultTag child : tags.values()) {
            DefaultTag tag = this._recursiveSearchTags(child.getTags(), tagID);
            if (tag == null) continue;
            return tag;
        }
        return null;
    }

    public Map<String, DefaultTag> getTags(Map<String, Object> contextualParameters) {
        if (contextualParameters.get("siteName") == null) {
            return null;
        }
        Site site = this._siteManager.getSite((String)contextualParameters.get("siteName"));
        if (site == null) {
            String errorMessage = "Unable to load tags configuration values for site " + (String)contextualParameters.get("siteName");
            this.getLogger().error(errorMessage);
            return null;
        }
        String skin = site.getSkinId();
        if (!this._skinTags.containsKey(skin)) {
            try {
                this.initializeTags(skin);
            }
            catch (Exception e) {
                String errorMessage = "Unable to load tags configuration values for skin " + skin;
                this.getLogger().error(errorMessage, (Throwable)e);
            }
        }
        return this._skinTags.get(skin);
    }

    protected void initializeTags(String skinName) throws Exception {
        Source otherSrc = null;
        try {
            otherSrc = this._resolver.resolveURI("skin:" + skinName + "://conf/link-themes.xml");
            if (otherSrc.exists()) {
                this.getLogger().error("In skin '" + skinName + "' (or one of its parent skin) the 'conf/link-themes.xml' file location is obsolete AND NOT SUPPORTED ANYMORE. Move the file conf/link-themes.xml to conf/link-directory.xml");
            }
        }
        finally {
            this._resolver.release(otherSrc);
        }
        Configuration configuration = this._directoryHelper.getSkinLinksConfiguration(skinName);
        if (!this._skinLocalIds.containsKey(skinName)) {
            this._skinLocalIds.put(skinName, new ArrayList());
        }
        Map<String, DefaultTag> tags = this.configureTags(configuration, skinName, null, "skin." + skinName);
        this._skinTags.put(skinName, tags);
    }

    protected Map<String, DefaultTag> configureTags(Configuration configuration, String skinName, DefaultTag parent, String defaultCatalogue) throws ConfigurationException {
        Configuration[] tagsConfiguration;
        HashMap<String, DefaultTag> themes = new HashMap<String, DefaultTag>();
        for (Configuration tagConfiguration : tagsConfiguration = configuration.getChild("definitions").getChildren("theme")) {
            String id = tagConfiguration.getAttribute("id", null);
            if (id == null) {
                this.getLogger().error("Missing attributed named \"id\" for theme configuration at " + tagConfiguration.getLocation() + ". Theme is ignored.");
                continue;
            }
            if (!Tag.NAME_PATTERN.matcher(id).matches()) {
                this.getLogger().error("Invalid tag ID \"" + id + "\" for theme configuration at " + tagConfiguration.getLocation() + ". It must match the pattern " + Tag.NAME_PATTERN.toString() + ". Theme is ignored.");
                continue;
            }
            if (this._skinLocalIds.get(skinName).contains(id)) {
                this.getLogger().error("A tag with the ID \"" + id + "\" for theme configuration at " + tagConfiguration.getLocation() + " already exists. Theme is ignored.");
                continue;
            }
            this._skinLocalIds.get(skinName).add(id);
            I18nizableText label = this.configureLabel(tagConfiguration, defaultCatalogue);
            I18nizableText description = this.configureDescription(tagConfiguration, defaultCatalogue);
            DefaultTag theme = new DefaultTag(id, id, parent, label, description);
            themes.put(id, theme);
        }
        return themes;
    }
}

