<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:variable name="configurable" select="ametys:serviceParameter('configurable')/text()"/>
    <xsl:variable name="display-user-links" select="ametys:serviceParameter('displayUserLinks')/text()"/>
    
    <!-- Display the configure links button if the service is configurable -->
    <xsl:template name="display-configure-links-btn-service">    
        <xsl:param name="maxCheckedLinks"/>
        <xsl:if test="$configurable = 'true'">
	        <xsl:call-template name="configure-links-btn-and-dialog">
	            <xsl:with-param name="links" select="/links/link"/>
	            <xsl:with-param name="maxCheckedLinks" select="$maxCheckedLinks"/>
	        </xsl:call-template>                                     
        </xsl:if>
    </xsl:template>
    
    <!-- Configure links button for a service or an input data -->
    <xsl:template name="configure-links-btn-and-dialog">
        <xsl:param name="links"/>
        <xsl:param name="maxCheckedLinks"/>
        <xsl:param name="savingId" select="@zoneItemId"/>
        
        <xsl:variable name="buttonId" select="substring-after(math:random(), '.')"/>
        <script type="text/javascript">
            <!-- Rendering of the button -->    
            <xsl:call-template name="configure-links-btn">
                <xsl:with-param name="buttonId" select="$buttonId"/>
            </xsl:call-template>
            
            <!-- Set up the dialog's form -->
            <xsl:call-template name="configure-links-dialog-and-form">
                <xsl:with-param name="maxCheckedLinks" select="$maxCheckedLinks"/>
                <xsl:with-param name="links" select="$links"/>
                <xsl:with-param name="buttonId" select="$buttonId"/>
                <xsl:with-param name="savingId" select="$savingId"/>
            </xsl:call-template> 
             
             <!-- Logic of the button and its dialog -->
             <xsl:call-template name="configure-links-btn-script">
                 <xsl:with-param name="maxCheckedLinks" select="$maxCheckedLinks"/>
                 <xsl:with-param name="buttonId" select="$buttonId"/>
             </xsl:call-template>
        
        </script>
    </xsl:template>
    
    <!-- Default rendering for a service -->
    <xsl:template name="configure-links-btn">
        <xsl:param name="buttonId"/>
        
        <xsl:choose>
            <xsl:when test="not(ametys:user())">
                <!-- The user is not connected: the button is not displayed -->
            </xsl:when>
            <xsl:otherwise>
                document.writeln("&lt;p class=\"configure-links\"&gt;&lt;a id=\"configure-links-hyperlink-<xsl:value-of select="$buttonId"/>\" class=\"configure-links-service-button\" href=\"javascript:void(0)\" title=\"<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_LINKS_TITLE" i18n:catalogue="plugin.link-directory"/>\" i18n:attr=\"title\"&gt;<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_LINKS" i18n:catalogue="plugin.link-directory"/>&lt;/a&gt;&lt;/p&gt;");
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- The dialog and the form when clicking the button -->
    <xsl:template name="configure-links-dialog-and-form"> 
        <xsl:param name="maxCheckedLinks"/>
        <xsl:param name="links"/>
        <xsl:param name="buttonId"/>
        <xsl:param name="savingId" select="@zoneItemId"/>
        
        document.writeln("&lt;div id=\"configure-links-dialog-<xsl:value-of select="$buttonId"/>\" title=\"<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_LINKS_TITLE" i18n:catalogue="plugin.link-directory"/>\" style=\"display:none;\" i18n:attr=\"title\"&gt;");
            document.writeln("&lt;form id=\"configure-links-form-<xsl:value-of select="$buttonId"/>\"&gt;");
                document.writeln("&lt;p class=\"configure-links-dialog-text\"&gt;<i18n:translate><i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_DIALOG_TITLE" i18n:catalogue="plugin.link-directory"/><i18n:param name="maxCheckedLinks"><xsl:value-of select="$maxCheckedLinks"/></i18n:param></i18n:translate>&lt;/p&gt;")               
                document.writeln("&lt;input type=\"hidden\" id=\"saving-id-<xsl:value-of select="$buttonId"/>\" name=\"saving-id\" value=\"<xsl:value-of select="$savingId"/>\"&gt;");

               <xsl:for-each select="$links">
                     <xsl:apply-templates select="." mode="configure-field">
                         <xsl:with-param name="buttonId" select="$buttonId"/>
                     </xsl:apply-templates>
               </xsl:for-each>
               
           document.writeln("&lt;/form&gt;");
        document.writeln("&lt;/div&gt;");
    </xsl:template>
    
    <!-- Configure the checkboxes of the form -->    
    <xsl:template match="link" mode="configure-field">
        <xsl:param name="buttonId"/>
        <xsl:param name="user-link-remove-text"><xsl:call-template name="user-link-remove-text"/></xsl:param>
    
        <xsl:variable name="label">
            <xsl:choose>
                <xsl:when test="normalize-space(@title) != ''">
                    <xsl:value-of select="@title"/>
                </xsl:when>
                <xsl:when test="normalize-space(@pageTitle) != ''">
                    <xsl:value-of select="@pageTitle"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="@url"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        document.writeln("&lt;div class=\"field\"&gt;");
            <xsl:choose>
                <xsl:when test="@user-selected = 'true'">
                    document.writeln("&lt;input type=\"checkbox\" checked=\"checked\" data-serverid=\"<xsl:value-of select="@id"/>\"/&gt;");
                </xsl:when>
                <xsl:otherwise>
                    document.writeln("&lt;input type=\"checkbox\" data-serverid=\"<xsl:value-of select="@id"/>\"/&gt;");
                </xsl:otherwise>
            </xsl:choose>
            document.writeln("&lt;label for=\"label-<xsl:value-of select="ametys:escapeJS($label)"/>\"&gt;");
                document.writeln("&lt;span&gt;<xsl:value-of select="ametys:escapeJS($label)"/>&lt;/span&gt;");
            document.writeln("&lt;/label&gt;");
            <xsl:if test="@userLink = 'true'">
                var aTag = "&lt;a href=\"javascript:void(0);\" onclick=\"removeLink<xsl:value-of select="$buttonId"/>(this, '<xsl:value-of select="@id"/>');\" class=\"remove-user-link\" title=\"<i18n:text i18n:catalogue="plugin.link-directory" i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_DIALOG_REMOVE_USER_LINK_TOOLTIP"/>\"&gt;"
                    + "<xsl:copy-of select="$user-link-remove-text"/>"
                    + "&lt;/a&gt;";
                document.writeln(aTag);
            </xsl:if>
            document.writeln("&lt;div class=\"clearfix\"&gt;&lt;/div&gt;");
        document.writeln("&lt;/div&gt;");
    </xsl:template>
    
    <xsl:template name="user-link-remove-text"><i18n:text i18n:catalogue="plugin.link-directory" i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_DIALOG_REMOVE_USER_LINK_DEFAULT_TEXT"/></xsl:template>
    
    <!--  Script associated to the configure links button -->
    <xsl:template name="configure-links-btn-script">
        <xsl:param name="maxCheckedLinks"/>
        <xsl:param name="buttonId"/>
        
        function saveUserPrefs<xsl:value-of select="$buttonId"/>()
        {   
            if ($j('#configure-links-form-<xsl:value-of select="$buttonId"/> input[type="checkbox"]:checked').length &gt; <xsl:value-of select="$maxCheckedLinks"/>)
            {
                alert("<i18n:translate>
                        <i18n:text i18n:key='PLUGINS_LINKDIRECTORY_MAX_LINKS_SELECTED_ALERT' i18n:catalogue='plugin.link-directory'/>
                        <i18n:param name="maxCheckedLinks"><xsl:value-of select="$maxCheckedLinks"/></i18n:param>
                    </i18n:translate>");
                return;
            }
        
            var orderedLinks<xsl:value-of select="$buttonId"/> = [];
            $j('#configure-links-form-<xsl:value-of select="$buttonId"/> input[type="checkbox"]').each(function() {
                var box = $j(this);
                if (box.is(':checked'))
                {
                    orderedLinks<xsl:value-of select="$buttonId"/>.push(box.attr('data-serverid'));
                }
            });
            
            AmetysHelperLinkDirectory.saveUserPrefs(
                orderedLinks<xsl:value-of select="$buttonId"/>,
                null,
                "<xsl:value-of select="$site-uri-prefix"/>",
                "<xsl:value-of select="ametys:lang()"/>",
                $j('#saving-id-<xsl:value-of select="$buttonId"/>').val(),
                removeUserLinks<xsl:value-of select="$buttonId"/>,
                function() {
                    alert("<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_DIALOG_ERROR_SAVE_USERPREFS" i18n:catalogue="plugin.link-directory"/>");
                }
            );
        }
        
        function removeLink<xsl:value-of select="$buttonId"/>(aTag, aId)
        {
            aTag.parentElement.style.setProperty("display", "none");
            linksToRemove<xsl:value-of select="$buttonId"/>.push(aId);
        }
        
        function removeUserLinks<xsl:value-of select="$buttonId"/>()
        {
            AmetysHelperLinkDirectory.removeUserLinks(
                linksToRemove<xsl:value-of select="$buttonId"/>,
                "<xsl:value-of select="$site-uri-prefix"/>",
                reloadPage<xsl:value-of select="$buttonId"/>,
                function() {
                    alert("<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_DIALOG_ERROR_REMOVE_LINKS" i18n:catalogue="plugin.link-directory"/>");
                },
                reloadPage<xsl:value-of select="$buttonId"/>
            );
        }
        
        function reloadPage<xsl:value-of select="$buttonId"/>()
        {
            window.location.reload(); 
        }
        
        linksToRemove<xsl:value-of select="$buttonId"/> = [];
        
        $j('#configure-links-hyperlink-<xsl:value-of select="$buttonId"/>').on('click', function() {
            // Reset form to initial state
            $j('#configure-links-form-<xsl:value-of select="$buttonId"/>')[0].reset();
            // Open the dialog box
            $j('#configure-links-dialog-<xsl:value-of select="$buttonId"/>').dialog('open');
        });
        
        $j('#configure-links-dialog-<xsl:value-of select="$buttonId"/>').dialog({
            autoOpen: false,
            resizable: false,
            maxHeight: 435,
            width: 400,
            modal: true,
            buttons: {
                "<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_DIALOG_CONFIRM" i18n:catalogue="plugin.link-directory"/>": function() {
                    saveUserPrefs<xsl:value-of select="$buttonId"/>();
                    $j(this).dialog('close');
                },
                "<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_DIALOG_CANCEL" i18n:catalogue="plugin.link-directory"/>": function() {
                    var me = $j(this); 
                    // Cancel user links eventually removed
                    linksToRemove<xsl:value-of select="$buttonId"/> = [];
                    me.children("form").children(".field").each(function(index, item) {
                        item.style.removeProperty("display");
                    });
                    
                    // Close dialog box
                    me.dialog('close');
                }
            }
        });
    </xsl:template>
    
    <!-- Display the 'add user link' button if the service also displays user links (favorites) -->
    <xsl:template name="display-add-user-link-btn-service">
        <xsl:if test="$display-user-links = 'true'">
            <xsl:call-template name="add-user-link-btn-and-dialog">
                <xsl:with-param name="customTheme" select="@custom-theme"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <!-- 'Add user link' button for a service or an input data -->
    <xsl:variable name="userLinkBtnId" select="substring-after(math:random(), '.')"/>
    <xsl:template name="add-user-link-btn-and-dialog">
        <xsl:param name="customTheme" select="@custom-theme"/>
        <script type="text/javascript">
            <!-- Rendering of the button -->    
            <xsl:call-template name="add-user-link-btn">
                <xsl:with-param name="buttonId" select="$userLinkBtnId"/>
            </xsl:call-template>
            
            <!-- Set up the dialog's form -->
            <xsl:call-template name="add-user-link-dialog-and-form">
                <xsl:with-param name="buttonId" select="$userLinkBtnId"/>
            </xsl:call-template> 
             
             <!-- Logic of the button and its dialog -->
             <xsl:call-template name="add-user-link-btn-script">
                <xsl:with-param name="buttonId" select="$userLinkBtnId"/>
                <xsl:with-param name="customTheme" select="$customTheme"/>
             </xsl:call-template>
             
             <xsl:call-template name="add-user-link-btn-additional-script"/>
        </script>
    </xsl:template>
    
    <!-- Default rendering for a service -->
    <xsl:template name="add-user-link-btn">
        <xsl:param name="buttonId"/>
        
        <xsl:choose>
            <xsl:when test="not(ametys:user())">
                <!-- The user is not connected: the button is not displayed -->
            </xsl:when>
            <xsl:otherwise>
                document.writeln("&lt;p class=\"add-user-link\"&gt;&lt;a id=\"add-user-link-hyperlink-<xsl:value-of select="$buttonId"/>\" class=\"add-user-link-service-button\" href=\"javascript:void(0)\" title=\"<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_ADD_USER_LINK_TITLE" i18n:catalogue="plugin.link-directory"/>\" i18n:attr=\"title\"&gt;<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_ADD_USER_LINK" i18n:catalogue="plugin.link-directory"/>&lt;/a&gt;&lt;/p&gt;");
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- The dialog and the form when clicking the button -->
    <xsl:template name="add-user-link-dialog-and-form"> 
        <xsl:param name="buttonId"/>
        
        document.writeln("&lt;div id=\"add-user-link-dialog-<xsl:value-of select="$buttonId"/>\" title=\"<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_ADD_USER_LINK_TITLE" i18n:catalogue="plugin.link-directory"/>\" style=\"display:none;\" i18n:attr=\"title\"&gt;");
           document.writeln("&lt;form id=\"add-user-link-form-<xsl:value-of select="$buttonId"/>\"&gt;");
               <xsl:call-template name="input-text">
                   <xsl:with-param name="buttonId" select="$buttonId"/>
                   <xsl:with-param name="name">title</xsl:with-param>
                   <xsl:with-param name="labelKey">PLUGINS_LINKDIRECTORY_ADD_USER_LINK_DIALOG_FIELD_TITLE</xsl:with-param>
                   <xsl:with-param name="labelCatalogue">plugin.link-directory</xsl:with-param>
                   <xsl:with-param name="mandatory">true</xsl:with-param>
               </xsl:call-template>
               <xsl:call-template name="input-text">
                   <xsl:with-param name="buttonId" select="$buttonId"/>
                   <xsl:with-param name="name">url</xsl:with-param>
                   <xsl:with-param name="labelKey">PLUGINS_LINKDIRECTORY_ADD_USER_LINK_DIALOG_FIELD_URL</xsl:with-param>
                   <xsl:with-param name="labelCatalogue">plugin.link-directory</xsl:with-param>
                   <xsl:with-param name="mandatory">true</xsl:with-param>
               </xsl:call-template>
               
               <xsl:call-template name="input-text-warning">
                   <xsl:with-param name="buttonId" select="$buttonId"/>
                   <xsl:with-param name="name">url</xsl:with-param>
                   <xsl:with-param name="class">add-links-dialog-url-warning</xsl:with-param>
                   <xsl:with-param name="warningKey">PLUGINS_CORE_REGEXP_INVALID_HTTP_URL_START</xsl:with-param>
                   <xsl:with-param name="warningCatalogue">plugin.core</xsl:with-param>
               </xsl:call-template>
           
           document.writeln("&lt;/form&gt;");
        document.writeln("&lt;/div&gt;");
    </xsl:template>
    
    <xsl:template name="input-text">
        <xsl:param name="buttonId"/>
        <xsl:param name="name"/>
        <xsl:param name="labelKey"/>
        <xsl:param name="labelCatalogue"/>
        <xsl:param name="mandatory">false</xsl:param>
        
        document.writeln("&lt;div class=\"field\"&gt;&lt;div class=\"label\"&gt;");
        document.writeln("&lt;label for=\"<xsl:value-of select="$name"/>-<xsl:value-of select="$buttonId"/>\"&gt;");
        document.writeln("<i18n:text><xsl:attribute name="i18n:catalogue"><xsl:value-of select="$labelCatalogue"/></xsl:attribute><xsl:attribute name="i18n:key"><xsl:value-of select="$labelKey"/></xsl:attribute></i18n:text>");
        <xsl:if test="$mandatory = 'true'">
            document.writeln("&lt;span class=\"mandatory-marker\"&gt;<i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/>&lt;/span&gt;");
        </xsl:if>
        document.writeln("&lt;/label&gt;&lt;/div&gt;");
        document.writeln("&lt;div class=\"input\"&gt;");
        document.writeln("&lt;input type=\"text\" name=\"<xsl:value-of select="$name"/>\" class=\"text\" id=\"<xsl:value-of select="$name"/>-<xsl:value-of select="$buttonId"/>\" /&gt;");
        document.writeln("&lt;/div&gt;&lt;div class=\"field-end\"&gt;&lt;/div&gt;&lt;/div&gt;");
    </xsl:template>
    
    <xsl:template name="input-text-warning">
        <xsl:param name="buttonId"/>
        <xsl:param name="name"/>
        <xsl:param name="class"/>
        <xsl:param name="warningKey" />
        <xsl:param name="warningCatalogue" />
        
        document.writeln("&lt;div class=\"<xsl:value-of select="$class"/>\" style=\"display:none\" id=\"warning-<xsl:value-of select="$name"/>-<xsl:value-of select="$buttonId"/>\" &gt;");
        document.writeln("<i18n:text><xsl:attribute name="i18n:catalogue"><xsl:value-of select="$warningCatalogue"/></xsl:attribute><xsl:attribute name="i18n:key"><xsl:value-of select="$warningKey"/></xsl:attribute></i18n:text>");
        document.writeln("&lt;/div&gt;");
    </xsl:template>
    
    <!--  Script associated to the 'add user link' button -->
    <xsl:template name="add-user-link-btn-script">
        <xsl:param name="buttonId"/>
        <xsl:param name="customTheme" select="@custom-theme"/>
        
        function addUserLink<xsl:value-of select="$buttonId"/>()
        {
            $j.ajax({
                url: '<xsl:value-of select="$site-uri-prefix"/>/_plugins/link-directory/add-user-link',
                data: {
                    siteName: "<xsl:value-of select="ametys:site()"/>",
                    lang: "<xsl:value-of select="ametys:lang()"/>",
                    title: $j("#title-<xsl:value-of select="$buttonId"/>").val(),
                    url: $j("#url-<xsl:value-of select="$buttonId"/>").val(),
                    themes: "<xsl:value-of select="$customTheme"/>"
                },
                method: 'POST',
                success: function(data) { window.location.reload(); },
                error: function(data) {alert("<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_ADD_USER_LINK_DIALOG_ERROR" i18n:catalogue="plugin.link-directory"/>");}
            });
        }
        
        $j('#url-<xsl:value-of select="$buttonId"/>').on('keyup', function() {
            var warningDiv = $j("#warning-url-<xsl:value-of select="$buttonId"/>");
            
            var value = $j(this).val();
            if (value != "" &amp;&amp; !value.startsWith("http://") &amp;&amp; !value.startsWith("https://"))
            {
                warningDiv.show();
            }
            else
            {
                warningDiv.hide();
            }
        });
        
        $j('#add-user-link-hyperlink-<xsl:value-of select="$buttonId"/>').on('click', function() {
            $j('#add-user-link-dialog-<xsl:value-of select="$buttonId"/>').dialog('open');
        });
        
        $j('#add-user-link-dialog-<xsl:value-of select="$buttonId"/>').dialog({
            autoOpen: false,
            resizable: false,
            maxHeight: 435,
            width: 400,
            modal: true,
            buttons: {
                "<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_ADD_USER_LINK_DIALOG_CONFIRM" i18n:catalogue="plugin.link-directory"/>": function() {
                    var $title = $j("#title-<xsl:value-of select="$buttonId"/>");
                    var $url = $j("#url-<xsl:value-of select="$buttonId"/>");
                    if ($title.val() == "")
                    {
                        $title.focus();
                        return;
                    }
                    if ($url.val() == "")
                    {
                        $url.focus();
                        return;
                    }
                    
                    addUserLink<xsl:value-of select="$buttonId"/>();
                    $j(this).dialog('close');
                },
                "<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_ADD_USER_LINK_DIALOG_CANCEL" i18n:catalogue="plugin.link-directory"/>": function() {
                    // Reinitialize text inputs
                    $j("#title-<xsl:value-of select="$buttonId"/>").val("");
                    $j("#url-<xsl:value-of select="$buttonId"/>").val("");
                    $j("#warning-url-<xsl:value-of select="$buttonId"/>").hide();
            
                    $j(this).dialog('close');
                }
            }
        });
    </xsl:template>
    
    <xsl:template name="add-user-link-btn-additional-script"/>
    
     <!--  Rendering of the errors -->
    <xsl:template name="unknown-themes">
        <xsl:param name="data"/>
        <xsl:param name="count">0</xsl:param>
        <xsl:param name="target">service</xsl:param>
        
        <xsl:if test="$count &gt; 0 and $rendering-context = 'back'">
            <div class="ametys-cms-zone-error">
               <div class="ametys-cms-zone-item-error">
                   <div class="ametys-cms-content-inline-error">
                       <table cellspacing="0" cellpadding="0">
                            <tbody>
                                <tr>
                                    <td style="vertical-align: top; width: 36px;">
                                        <img alt="" src="{$uri-prefix}/plugins/web/resources/img/skin/zoneitem_error_32.png"/>
                                    </td>
                                    <td>
                                        <strong><i18n:text i18n:key="PLUGINS_LINKDIRECTORY_UNKNOWN_THEME_TITLE" i18n:catalogue="plugin.link-directory"/></strong>
                                        <br/>
                                        <em>
                                            <xsl:choose>
                                                <xsl:when test="$target = 'service'">
                                                   <i18n:translate>
                                                       <i18n:text i18n:key="PLUGINS_LINKDIRECTORY_SERVICE_UNKNOWN_THEMES" i18n:catalogue="plugin.link-directory"/>
                                                       <i18n:param name="count"><xsl:value-of select="$count"/></i18n:param>
	                                               </i18n:translate>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <i18n:translate>
                                                        <i18n:text i18n:key="PLUGINS_LINKDIRECTORY_INPUTDATA_UNKNOWN_THEMES" i18n:catalogue="plugin.link-directory"/>
                                                        <i18n:param name="count"><xsl:value-of select="$count"/></i18n:param>
                                                        <i18n:param name="data"><xsl:value-of select="$data"/></i18n:param>
                                                    </i18n:translate>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </em>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
    