/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.linkdirectory.theme;

import javax.jcr.Node;

import org.ametys.cms.tag.jcr.JCRTag;
import org.ametys.cms.tag.jcr.TagFactory;
import org.ametys.plugins.repository.AmetysObject;

/**
 * {@link JCRTag} for storing tag informations.
 */
public class ThemeJCR extends JCRTag
{
    /**
     * Creates a {@link JCRTag}.
     * @param node the node backing this {@link AmetysObject}.
     * @param parentPath the parent path in the Ametys hierarchy.
     * @param factory the {@link TagFactory} which creates the AmetysObject.
     */
    public ThemeJCR (Node node, String parentPath, ThemeFactory factory)
    {
        super(node, parentPath, factory);
    }
}
