/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.cms.data.Binary;
import org.ametys.cms.transformation.AbstractURIResolver;
import org.ametys.cms.transformation.ConsistencyChecker;
import org.ametys.core.util.FilenameUtils;
import org.ametys.core.util.ImageResolverHelper;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.linkdirectory.repository.DefaultLink;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.URIPrefixHandler;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class LinkMetadataURIResolver
extends AbstractURIResolver
implements Serviceable,
Contextualizable,
PluginAware {
    private static final Pattern _OBJECT_URI_PATTERN = Pattern.compile("([^?]*)\\?objectId=(.*)");
    private AmetysObjectResolver _resolver;
    private URIPrefixHandler _prefixHandler;
    private RenderingContextHandler _renderingContexthandler;
    private SiteManager _siteManager;
    private Context _context;
    private String _pluginName;

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._prefixHandler = (URIPrefixHandler)manager.lookup(URIPrefixHandler.ROLE);
        this._renderingContexthandler = (RenderingContextHandler)manager.lookup(RenderingContextHandler.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
    }

    public String getType() {
        return "link-data";
    }

    protected String _resolve(String uri, String uriArgument, boolean download, boolean absolute, boolean internal) {
        try {
            Request request = ContextHelper.getRequest((Context)this._context);
            Info info = this._getInfo(uri, request);
            DefaultLink link = info.getLink();
            String dataPath = info.getDataPath();
            if (link == null) {
                throw new IllegalStateException("Cannot resolve a local link to an unknown link for uri " + request.getRequestURI());
            }
            Binary binary = (Binary)link.getValue(dataPath);
            String filename = FilenameUtils.encodeName((String)binary.getFilename());
            String baseName = org.apache.commons.io.FilenameUtils.getBaseName((String)filename);
            String extension = org.apache.commons.io.FilenameUtils.getExtension((String)filename);
            StringBuilder resultPath = new StringBuilder();
            resultPath.append("/_plugins/").append(this._pluginName).append("/_links").append(FilenameUtils.encodePath((String)link.getPath())).append("/_data/").append(dataPath).append("/").append(baseName).append(uriArgument).append((String)(extension.isEmpty() ? "" : "." + extension));
            String result = this._getUri(resultPath.toString(), link, absolute, internal);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("objectId", link.getId());
            if (download) {
                params.put("download", "true");
            }
            return URIUtils.encodeURI((String)result, params);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected String resolveImageAsBase64(String uri, int height, int width, int maxHeight, int maxWidth, int cropHeight, int cropWidth) {
        String string;
        block9: {
            Request request = ContextHelper.getRequest((Context)this._context);
            Info info = this._getInfo(uri, request);
            DefaultLink link = info.getLink();
            String dataPath = info.getDataPath();
            if (link == null) {
                throw new IllegalStateException("Cannot resolve a local link to an unknown link for uri " + request.getRequestURI());
            }
            Binary binary = (Binary)link.getValue(dataPath);
            InputStream dataIs = binary.getInputStream();
            try {
                string = ImageResolverHelper.resolveImageAsBase64((InputStream)dataIs, (String)binary.getMimeType(), (int)height, (int)width, (int)maxHeight, (int)maxWidth, (int)cropHeight, (int)cropWidth);
                if (dataIs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dataIs != null) {
                        try {
                            dataIs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            dataIs.close();
        }
        return string;
    }

    public String getMimeType(String uri) {
        try {
            Request request = ContextHelper.getRequest((Context)this._context);
            Info info = this._getInfo(uri, request);
            DefaultLink link = info.getLink();
            String dataPath = info.getDataPath();
            if (link == null) {
                throw new IllegalStateException("Cannot resolve a local link to an unknown link for uri " + request.getRequestURI());
            }
            Binary binary = (Binary)link.getValue(dataPath);
            return binary.getMimeType();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String _getUri(String path, DefaultLink object, boolean absolute, boolean internal) {
        String siteName = object.getSiteName();
        if (internal) {
            return "cocoon://" + siteName + path;
        }
        if (absolute) {
            if (this._renderingContexthandler.getRenderingContext() == RenderingContext.FRONT) {
                Site site = this._siteManager.getSite(siteName);
                String[] aliases = site.getUrlAliases();
                return aliases[Math.abs(path.hashCode()) % aliases.length] + path;
            }
            return this._prefixHandler.getAbsoluteUriPrefix() + "/" + siteName + path;
        }
        return this._prefixHandler.getUriPrefix(siteName) + path;
    }

    public ConsistencyChecker.CHECK checkLink(String uri, boolean shortTest) {
        return ConsistencyChecker.CHECK.SUCCESS;
    }

    public I18nizableText getLabel(String uri) {
        try {
            Request request = ContextHelper.getRequest((Context)this._context);
            Info info = this._getInfo(uri, request);
            return new I18nizableText("plugin.cms", "PLUGINS_CMS_LINK_METADATA_LABEL", Collections.singletonList(info.getDataPath()));
        }
        catch (UnknownAmetysObjectException e) {
            return new I18nizableText("plugin.cms", "PLUGINS_CMS_LINK_METADATA_UNKNOWN");
        }
    }

    private Info _getInfo(String uri, Request request) {
        Info info = new Info(this);
        Matcher matcher = _OBJECT_URI_PATTERN.matcher(uri);
        if (!matcher.matches()) {
            throw new IllegalStateException("Missing objectId parameter to resolve a local link for uri " + request.getRequestURI());
        }
        info.setDataPath(matcher.group(1));
        String objectId = matcher.group(2);
        DefaultLink link = (DefaultLink)this._resolver.resolveById(objectId);
        info.setLink(link);
        return info;
    }

    protected class Info {
        private String _dataPath;
        private DefaultLink _link;

        protected Info(LinkMetadataURIResolver this$0) {
        }

        public String getDataPath() {
            return this._dataPath;
        }

        public void setDataPath(String path) {
            this._dataPath = path;
        }

        public DefaultLink getLink() {
            return this._link;
        }

        public void setLink(DefaultLink link) {
            this._link = link;
        }
    }
}

