/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory;

import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Map;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.user.status.PersonalDataPolicy;
import org.ametys.core.user.status.PersonalDataProcessingException;
import org.ametys.core.user.status.UserStatusInfo;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.plugins.linkdirectory.link.LinkDAO;
import org.ametys.plugins.linkdirectory.repository.DefaultLink;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.runtime.config.Config;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class UserLinksDataPolicy
implements PersonalDataPolicy,
Serviceable {
    protected DirectoryHelper _directoryHelper;
    protected LinkDAO _linkDAO;
    protected SiteManager _siteManager;
    private Period _retentionPeriod;

    public void service(ServiceManager manager) throws ServiceException {
        this._directoryHelper = (DirectoryHelper)((Object)manager.lookup(DirectoryHelper.ROLE));
        this._linkDAO = (LinkDAO)((Object)manager.lookup(LinkDAO.ROLE));
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        Long config = (Long)Config.getInstance().getValue("link-directory.user-links.data-policy.retention.period", false, null);
        this._retentionPeriod = config != null && config >= 0L ? Period.ofMonths(config.intValue()) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PersonalDataPolicy.AnonymizationResult process(UserStatusInfo userStatusInfo) throws PersonalDataProcessingException {
        if (this._retentionPeriod == null) {
            return PersonalDataPolicy.AnonymizationResult.TOO_EARLY;
        }
        if (!userStatusInfo.getMissingSinceDate().isBefore(ZonedDateTime.now().minus(this._retentionPeriod))) return PersonalDataPolicy.AnonymizationResult.TOO_EARLY;
        int handled = 0;
        UserIdentity userIdentity = userStatusInfo.getUserIdentity();
        try (AmetysObjectIterable sites = this._siteManager.getSites();){
            AmetysObjectIterator ametysObjectIterator;
            for (Site site : sites) {
                AmetysObjectIterable sitemaps = site.getSitemaps();
                try {
                    for (Sitemap sitemap : sitemaps) {
                        AmetysObjectIterable<DefaultLink> userLinks = this._directoryHelper.getUserLinks(site.getName(), sitemap.getName(), userIdentity);
                        try {
                            for (DefaultLink link : userLinks) {
                                this._linkDAO.deleteLink(link);
                                ++handled;
                            }
                        }
                        finally {
                            if (userLinks == null) continue;
                            userLinks.close();
                        }
                    }
                }
                finally {
                    if (sitemaps == null) continue;
                    sitemaps.close();
                }
            }
            if (handled > 0) {
                ForensicLogger.info((String)"data.policy.gdpr.remove.user.links", Map.of("handled", Integer.toString(handled), "identity", userIdentity), (UserIdentity)UserPopulationDAO.SYSTEM_USER_IDENTITY);
                ametysObjectIterator = PersonalDataPolicy.AnonymizationResult.PROCESSED;
                return ametysObjectIterator;
            }
            ametysObjectIterator = PersonalDataPolicy.AnonymizationResult.NO_DATA;
            return ametysObjectIterator;
        }
        catch (AmetysRepositoryException e) {
            throw new PersonalDataProcessingException("An error prevented the processing of the links for user '" + String.valueOf(userIdentity) + "'.", (Throwable)e);
        }
    }
}

