/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory;

import java.util.Arrays;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.service.StaticService;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class LinkDirectoryService
extends StaticService {
    public static final String DISPLAY_USER_LINKS_PARAMETER = "displayUserLinks";
    public static final String CONFIGURABLE_LINKS_PARAMETER = "configurable";
    private DirectoryHelper _directoryHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._directoryHelper = (DirectoryHelper)((Object)smanager.lookup(DirectoryHelper.ROLE));
    }

    public boolean isCacheable(Page currentPage, ZoneItem zoneItem) {
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        boolean configurable = (Boolean)serviceParameters.getValue(CONFIGURABLE_LINKS_PARAMETER, false, (Object)false);
        boolean displayUserLinks = (Boolean)serviceParameters.getValue(DISPLAY_USER_LINKS_PARAMETER, false, (Object)false);
        if (configurable || displayUserLinks) {
            return false;
        }
        if (currentPage != null) {
            String[] themes = serviceParameters.hasValue("themes") ? (String[])serviceParameters.getValue("themes") : new String[]{};
            String siteName = currentPage.getSiteName();
            String language = currentPage.getSitemapName();
            return !this._directoryHelper.hasRestrictions(siteName, language, Arrays.asList(themes)) && !this._directoryHelper.hasInternalUrl(siteName, language, Arrays.asList(themes));
        }
        return true;
    }
}

