/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.dynamic;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.linkdirectory.dynamic.DynamicInformationException;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractInternalDynamicInformationGenerator
extends ServiceableGenerator {
    public static final String DYNAMIC_INFORMATION = "dynamic-information";
    public static final String SHORT_VALUE = "short-value";
    public static final String LONG_VALUE = "long-value";
    public static final String TOOLTIP = "tooltip";
    public static final String ITEM = "item";
    public static final String ITEM_TITLE = "title";
    public static final String ITEM_SUMMARY = "summary";
    public static final String ITEM_FOOTER = "footer";
    public static final String ERROR = "error";
    public static final String ERROR_ATTRIBUTE_TYPE = "type";
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)DYNAMIC_INFORMATION);
        try {
            this.saxShortValue();
            this.saxLongValue();
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)TOOLTIP);
            this.saxTooltips();
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)TOOLTIP);
        }
        catch (DynamicInformationException e) {
            this.saxError(e);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)DYNAMIC_INFORMATION);
        this.contentHandler.endDocument();
    }

    protected UserIdentity getCurrentUser() {
        return this._currentUserProvider.getUser();
    }

    protected String getCurrentLanguage() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        return request.getParameter("lang");
    }

    protected int getMaxItems() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        try {
            return Integer.parseInt(request.getParameter("maxItems"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected void saxError(DynamicInformationException e) throws SAXException {
        if (e.isSilent()) {
            this.getLogger().warn("Unable to sax dynamic information", (Throwable)e);
        } else {
            this.getLogger().error("Unable to sax dynamic information", (Throwable)e);
        }
        DynamicInformationException.ExceptionType type = e.getType();
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute(ERROR_ATTRIBUTE_TYPE, type.name());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)ERROR, (Attributes)attr);
        I18nizableText errorMessage = new I18nizableText("plugin.link-directory", "PLUGINS_LINKDIRECTORY_DYNAMIC_INFO_PROVIDER_ERROR_" + type.name().toUpperCase());
        errorMessage.toSAX(this.contentHandler);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)ERROR);
    }

    protected abstract void saxShortValue() throws SAXException, DynamicInformationException;

    protected abstract void saxLongValue() throws SAXException, DynamicInformationException;

    protected abstract void saxTooltips() throws SAXException, DynamicInformationException;

    protected void saxItem(String title, String summary, String footer) throws SAXException, DynamicInformationException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)ITEM);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)ITEM_TITLE, (String)(title == null ? "" : title));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)ITEM_SUMMARY, (String)(summary == null ? "" : summary));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)ITEM_FOOTER, (String)(footer == null ? "" : footer));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)ITEM);
    }

    protected void saxItem(Date title, String summary, String footer) throws SAXException, DynamicInformationException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)ITEM);
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute(ERROR_ATTRIBUTE_TYPE, "date");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)ITEM_TITLE, (Attributes)attr, (String)DateUtils.dateToString((Date)title));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)ITEM_SUMMARY, (String)(summary == null ? "" : summary));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)ITEM_FOOTER, (String)(footer == null ? "" : footer));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)ITEM);
    }
}

