/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.link;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.linkdirectory.link.LinkDAO;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class RemoveUserLinkAction
extends ServiceableAction {
    protected LinkDAO _linkDAO;
    protected CurrentUserProvider _currentUserProvider;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
        this._linkDAO = (LinkDAO)((Object)smanager.lookup(LinkDAO.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap<String, String> result = new HashMap<String, String>();
        UserIdentity user = this._currentUserProvider.getUser();
        if (user != null) {
            String idsAsString = request.getParameter("ids");
            Object[] array = this._jsonUtils.convertJsonToArray(idsAsString);
            ArrayList<String> linksToRemove = new ArrayList<String>();
            for (Object id : array) {
                if (!(id instanceof String)) continue;
                linksToRemove.add((String)id);
            }
            this._deleteLinks(request, linksToRemove);
            result.put("error", "none");
        } else {
            result.put("error", "unauthenticated-user");
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> _deleteLinks(Request request, List<String> ids) {
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            List<String> list = this._linkDAO.deleteLinks(ids);
            return list;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }
}

