<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2017 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
     xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
     exclude-result-prefixes="ametys i18n">

    <xsl:variable name="date-format" select="ametys:translate('plugin.link-directory:PLUGINS_LINKDIRECTORY_SERVICE_DYNAMIC_INFO_DATE_FORMAT')"></xsl:variable>
    <xsl:variable name="time-format" select="ametys:translate('plugin.link-directory:PLUGINS_LINKDIRECTORY_SERVICE_DYNAMIC_INFO_TIME_FORMAT')"></xsl:variable>
    
    <xsl:template match="/dynamic-information">
        <dynamic-information>
            <xsl:apply-templates select="dynamic-information" />
        </dynamic-information>
    </xsl:template>

    <xsl:template match="dynamic-information[@id]">
        <dynamic-information id="{@id}">
            <xsl:if test="error">
                <xsl:attribute name="error"><xsl:value-of select="error/@type"/></xsl:attribute>
            </xsl:if>
            <xsl:apply-templates select="short-value" />
            <xsl:apply-templates select="long-value" />
            <xsl:if test="tooltip/item">
                <xsl:apply-templates select="tooltip" />
            </xsl:if>
            <xsl:apply-templates select="error" />
        </dynamic-information>
    </xsl:template>

    <xsl:template match="short-value">
        <span class="link-info-short-value" data-ametys-link-role="short-value">
            <xsl:apply-templates />
        </span>
    </xsl:template>

    <xsl:template match="long-value">
        <span class="link-info-long-value" data-ametys-link-role="long-value">
            <xsl:apply-templates />
        </span>
    </xsl:template>
    <xsl:template match="tooltip">
        <span class="link-info-tooltip" data-ametys-link-role="long-tooltip">
            <xsl:apply-templates select="item" />
        </span>
    </xsl:template>

    <xsl:template match="item">
        <span class="link-info-item">
            <xsl:apply-templates select="title" />
            <xsl:apply-templates select="summary" />
            <xsl:apply-templates select="footer" />
        </span>
    </xsl:template>

    <xsl:template match="title">
        <span class="link-info-title">
            <xsl:choose>
                <xsl:when test="@type = 'date'">
                    <span class="link-info-date">
                        <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-format}" value="{.}"/>
                    </span>
                    <xsl:text> </xsl:text>
                    <span class="link-info-time">
                        <i18n:time src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$time-format}" value="{.}"/>
                    </span>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates />
                </xsl:otherwise>
            </xsl:choose>
        </span>
    </xsl:template>

    <xsl:template match="summary">
        <span class="link-info-summary">
            <xsl:apply-templates />
        </span>
    </xsl:template>

    <xsl:template match="footer">
        <span class="link-info-footer">
            <xsl:apply-templates />
        </span>
    </xsl:template>
    
    <xsl:template match="error">
        <span class="link-info-error-message" data-ametys-link-role="error">
            <xsl:apply-templates />
        </span>
    </xsl:template>

    <!-- For copying -->
    <xsl:template match="*">
        <xsl:copy>
            <xsl:copy-of select="@*"></xsl:copy-of>

            <xsl:apply-templates />
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>