/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the representation of a link.
 */
Ext.define(
	"Ametys.plugins.linkdirectory.link.Link", 
	{
		config: {
			/**
			 * @cfg {String} id The unique id of the link
			 */
			/**
			 * @method getId Get the #cfg-id
			 * @return {String} The id
			 */
			/** @ignore */
			id: null,
			/**
			 * @cfg {String} title The title of the link
			 */
			/**
			 * @method getTitle Get the #cfg-title
			 * @return {String} The title
			 */
			/** @ignore */
			title: null,
			/**
			 * @cfg {String} url The url of the link
			 */
			/**
			 * @method getUrl Get the #cfg-url
			 * @return {String} The url
			 */
			/** @ignore */
			url: null,
			/**
			 * @cfg {String} internalUrl The internal url of the link
			 */
			/**
			 * @method getInternalUrl Get the #cfg-internal-url
			 * @return {String} The internal url
			 */
			/** @ignore */
			internalUrl: null,
            /**
             * @cfg {String} urlType The type of the link
             */
            /**
             * @method getUrlType Get the #cfg-urlType
             * @return {String} The type of the link
             */
            /** @ignore */
            urlType: null,
            /**
             * @cfg {String} pageTitle The title of the page if the type of the link is 'PAGE'
             */
            /**
             * @method getPageTitle Get the #cfg-pageTitle
             * @return {String} The page's title
             */
            /** @ignore */
            pageTitle: null,
			/**
			 * @cfg {String} alternative The alternative of the link
			 */
			/**
			 * @method getAlternative Get the #cfg-alternative
			 * @return {String} The alternative
			 */
			/** @ignore */
			alternative: null,
			/**
			 * @cfg {String} content The description of the link
			 */
			/**
			 * @method getContent Get the #cfg-content
			 * @return {String} The content
			 */
			/** @ignore */
			content: null,
			/**
			 * @cfg {String} lang The lang of the link
			 */
			/**
			 * @method getLang Get the #cfg-lang
			 * @return {String} The lang
			 */
			/** @ignore */
			lang: null,
			/**
			 * @cfg {Object[]} themes The link themes
			 */
			/**
			 * @method getTypes Get the #cfg-themes
			 * @return {String[]} The themes
			 */
			/** @ignore */
			themes: [],
			
			/**
			 * @cfg {Object} picture The picture object
			 */
			/**
			 * @method getPicture Get the #cfg-picture
			 * @return {Object} The picture
			 */
			/** @ignore */
			picture: {},
			
			/**
			 * @cfg {Object} pictureAlternative The text alternative for picture
			 */
			/**
			 * @method getPictureAlternative Get the #cfg-pictureAlternative
			 * @return {Object} The alternative for picture
			 */
			/** @ignore */
			pictureAlternative: {},
			
			/**
			 * @cfg {Number} position The position within the sibling links
			 */
			/**
			 * @method getPosition Get the #cfg-position
			 * @return {Number} The position within the sibling links
			 */
			/** @ignore */
			position: 0,
			
			/**
			 * @cfg {Number} count The total count of links
			 */
			/**
			 * @method getCount Get the #cfg-count
			 * @return {Number} The total count of links
			 */
			/** @ignore */
			count: 0,
			
			/**
			 * @cfg {String} isRestricted True if the link has access limitations
			 */
			/**
			 * @method getIsRestricted Get the #cfg-isRestricted
			 * @return {String} The restricted status
			 */
			/** @ignore */
			isRestricted: false,
			
			/**
			 * @cfg {String} dynamicInfoProvider The provider of dynamic information for this link
			 */
			/**
			 * @method getDynamicInfoProvider Get the #cfg-dynamicInfoProvider
			 * @return {String} The if of provider of dynamic information
			 */
			/** @ignore */
			dynamicInfoProvider: null,
			
			/**
			 * @cfg {String} color The color of the link
			 */
			/**
			 * @method getColor Get the #cfg-color
			 * @return {String} The color
			 */
			/** @ignore */
			color: null,
			
			/**
			 * @cfg {String} page The page of the link
			 */
			/**
			 * @method getPage Get the #cfg-page
			 * @return {String} The page
			 */
			/** @ignore */
			page: null,
			
			/**
			 * @cfg {String} status The status of the link
			 */
			/**
			 * @method getStatus Get the #cfg-status
			 * @return {String} The status
			 */
			/** @ignore */
			status: null,
			
			/**
			 * @cfg {String} defaultVisibility The default visibility of the link
			 */
			/**
			 * @method getDefaultVisibility Get the #cfg-defaultVisibility
			 * @return {String} The default visibility
			 */
			/** @ignore */
			defaultVisibility: null
		},
		
		
		/**
		 * Creates a link instance
		 * @param {Object} config See configuration doc.
		 */
		constructor: function (config)
		{
			this.initConfig(config);
		},
		
		/**
		 * Get the link's properties
		 * @return {Object} The link's properties
		 */
		getProperties: function (initialProperty)
		{
			return Ext.apply ({
					id: this._id,
					title: this._title,
					url: this._url,
					dynamicInfoProvider: this._dynamicInfoProvider,
					internalUrl: this._internalUrl,
                    urlType: this._urlType,
                    pageTitle: this._pageTitle,
					lang: this._lang,
					restricted: this.isRestricted,
					themes: this._themes,
					count: this._count,
					position: this._position,
					color: this._color
				}, initialProperty
			);
		}
	}
);

