/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This factory creates Ametys.message.MessageTarget for a link.
 * 
 * See #createTargets to know more.
 * @private
 */
Ext.define("Ametys.plugins.linkdirectory.LinkDirectoryMessageTargetFactory",
	{
		extend: "Ametys.message.factory.DefaultMessageTargetFactory",

		/**
		 * Create the targets for a message
		 * @param {Object} parameters The parameters needed by the factory to create the message. Can not be null. Handled elements are
		 * @param {String[]} parameters.ids The link's identifiers. Must be present if links is empty
		 * @param {Ametys.plugins.linkdirectory.link.Link[]} parameters.links The links themselves. Must be present if ids is empty
		 * @param {Function} callback The callback function called when the targets are created. Parameters are
		 * @param {Ametys.message.MessageTarget[]} callback.targets The targets created. Cannot be null.
		 */
		createTargets: function (parameters, callback)
		{
			if (parameters.ids)
		    {
			    Ametys.plugins.linkdirectory.link.LinkDAO.getLinks([parameters.ids], this._createTargets, {scope: this, arguments: {callback: callback, parameters: parameters}});
		    }
			else if (parameters.links)
			{
				this._createTargets (parameters.links, {callback: callback, parameters: parameters});
			}
		},
		
		/**
		 * @private
		 * Create the link targets
		 * @param {Ametys.plugins.linkdirectory.link.Link[]} links The links
		 * @param {Object} args The callback arguments
		 */
		_createTargets: function (links, args)
		{
			delete args.parameters['ids'];
			delete args.parameters['links'];
			
			var targets = [];
			
			for (var i=0; i < links.length; i++)
			{
				targets.push(Ext.create("Ametys.message.MessageTarget", {
						id: this.getId(),
						parameters: Ext.merge(links[i].getProperties(args.parameters || {}), {link: links[i]})
					})
				);
			}
				
			args.callback(targets);
		}
	}
);

Ext.define("Ametys.message.LinkDirectoryMessageTarget",
	{
		override: "Ametys.message.MessageTarget",
		
		statics: 
		{
			/**
			 * @member Ametys.message.MessageTarget
			 * @readonly
			 * @property {String} LINK_DIRECTORY The target type is a link from link directory. See Ametys.plugins.linkdirectory.LinkDirectoryMessageTargetFactory parameters to know more of the associated parameters. 
			 */
			LINK_DIRECTORY: "link-directory"
		}
	}
);
