<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
   <!-- Stylesheet used to merge two files with skin inheritance -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <!-- Theme definition -->
    <xsl:variable name="inheritedDefs" select="/files/weak/link-themes/definitions/theme"/>
    <xsl:variable name="overridenDefs" select="/files/strong/link-themes/definitions/theme"/>
    
    <!-- Input data -->
    <xsl:variable name="inheritedInpudata" select="/files/weak/link-themes/inputdata/themes"/>
    <xsl:variable name="overridenInputdata" select="/files/strong/link-themes/inputdata/themes"/>
        
    <xsl:template match="/">
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="/files[strong/link-themes/@inherit='false']">
        <!-- Inheritance disabled -->
        <xsl:copy-of select="/files/strong/link-themes"/>
    </xsl:template>
    
    <xsl:template match="/files">
        <link-themes>
            <definitions>
                <!-- Inherited themes -->
                <xsl:apply-templates select="$inheritedDefs" mode="inherited-definition"/>
            
                <!-- Additional themes -->
                <xsl:variable name="additionalThemes" select="$overridenDefs[not(@id=$inheritedDefs/@id)]"/>
                <xsl:if test="$additionalThemes">
                    <xsl:comment>additional theme definition</xsl:comment>
                    <xsl:copy-of select="$additionalThemes"/>
                </xsl:if>
            </definitions>
            
            <inputdata>
                <!-- Inherited inputdata -->   
                <xsl:apply-templates select="$inheritedInpudata" mode="inherited-inputdata"/> 
                
                <!-- Additional inputdata -->
                <xsl:variable name="additionalInputdata" select="$overridenInputdata[not(@inputDataId=$inheritedInpudata/@inputDataId)]"/>
                <xsl:if test="$additionalInputdata">
                    <xsl:comment>additional input data</xsl:comment>
                    <xsl:copy-of select="$additionalInputdata"/>
                </xsl:if>
            </inputdata>
        </link-themes>
    </xsl:template>
    
    <!-- Definition themes removed because present in STRONG with remove='true' -->
    <xsl:template match="theme[@id=$overridenDefs[@remove='true']/@id]" mode="inherited-definition">
        <xsl:comment><xsl:value-of select="@id"/> removed by inheritance</xsl:comment>
    </xsl:template>
    
    <xsl:template match="theme" mode="inherited-definition">
        <xsl:variable name="id" select="@id"/>
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="node()" mode="inherited-definition"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- Themes with label changed because they are present in STRONG -->
    <xsl:template match="label" mode="inherited-definition">
        <xsl:variable name="id" select="../@id"/>
        
        <xsl:choose>
            <xsl:when test="$overridenDefs[@id=$id]/label">
                <xsl:comment>label changed by inheritance</xsl:comment>
                <xsl:apply-templates select="$overridenDefs[@id=$id]/label"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Themes with definition changed because they are present in STRONG -->
    <xsl:template match="description"  mode="inherited-definition">
        <xsl:variable name="id" select="../@id"/>
        
        <xsl:choose>
            <xsl:when test="$overridenDefs[@id=$id]/description">
                <xsl:comment>description changed by inheritance</xsl:comment>
                <xsl:apply-templates select="$overridenDefs[@id=$id]/description"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="themes[@inputDataId=$overridenInputdata[@remove='true']/@inputDataId]" mode="inherited-inputdata">
        <xsl:comment><xsl:value-of select="@inputDataId"/> removed by inheritance</xsl:comment>
    </xsl:template>
    
    <xsl:template match="themes"  mode="inherited-inputdata">
        <xsl:variable name="inputDataId" select="@inputDataId"/>
        <xsl:copy>
            <!-- inherited attributes -->
            <xsl:apply-templates select="@*"/>
            <!-- overriden attributes -->
            <xsl:apply-templates select="$overridenInputdata[@inputDataId=$inputDataId]/@*"/>
            
            <!-- Inherited themes -->
            <xsl:apply-templates select="theme" mode="inherited-inputdata"/>
            
            <!-- Additional themes -->
            <xsl:variable name="additionalThemes" select="$overridenInputdata[@inputDataId=$inputDataId]/theme[not(@id=theme/@id) and not(@lang=theme/@lang) and not(@remove='true')]"/>
            <xsl:if test="$additionalThemes">
                <xsl:comment>additional input data themes</xsl:comment>
                <xsl:copy-of select="$additionalThemes"/>
            </xsl:if>
        </xsl:copy>    
    </xsl:template>
    
    <xsl:template match="theme" mode="inherited-inputdata">
        <xsl:param name="inputDataId" select="../@inputDataId"/>
        <xsl:param name="id" select="@id"/>
        <xsl:param name="lang" select="@lang"/>
        
        <xsl:variable name="overridenInputdataTheme" select="$overridenInputdata[@inputDataId=$inputDataId]/theme[@id = $id and @lang = $lang]"/>
        
        <xsl:choose>
            <xsl:when test="$overridenInputdataTheme and $overridenInputdataTheme/@remove = 'true'">
                <xsl:comment><xsl:value-of select="$id"/>/<xsl:value-of select="$lang"/> removed by inheritance</xsl:comment>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
