<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:xalan="http://xml.apache.org/xalan" 
                xmlns:math="java.lang.Math"
                exclude-result-prefixes="ametys math xalan">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="gdpr:google-maps"/>
                    
	<xsl:variable name="service-title" select="string(ametys:serviceParameter('title')/text())"/>
	<xsl:variable name="service-height" select="ametys:serviceParameter('height')/text()"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">maps googlemaps</xsl:variable>
    <xsl:variable name="is-empty" select="false()"/>    
	<xsl:variable name="common-service-name">service-maps-google</xsl:variable>
	
    <xsl:variable name="uniqueId" select="concat('map_', substring-after(math:random(), '.'))"/>
    
    <!-- +
         | HEAD
         + -->    
          
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$service-title"/>  
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="common-service-head-js">
        <script type="text/javascript">
            function setUpMap_<xsl:value-of select="$uniqueId" />()
            {
	            var data = 
                {
                    iconBase: '<xsl:value-of select="ametys:absoluteUriPrefix()"/>/plugins/maps/service/poi-icons/<xsl:value-of select="ametys:skin()"/>/',
                    zoomLevel: <xsl:value-of select="zoomLevel"/>,
                    lat: <xsl:value-of select="center/@latitude"/>,
                    lng: <xsl:value-of select="center/@longitude"/>,
                    mapTypeId: '<xsl:value-of select="mapTypeId"/>',
                    markers: 
                    [
                        <xsl:for-each select="pointsOfInterest/entry[type/@value ='marker']">
                            {
                              lat: <xsl:value-of select="point/@latitude"/>,
                              lng: <xsl:value-of select="point/@longitude"/>,
                              title: '<xsl:value-of select="ametys:escapeJS(title)"/>',
                              description :'<xsl:value-of select="ametys:escapeJS(description)"/>',
                              icon: '<xsl:value-of select="icon"/>',
                              gtype: '<xsl:value-of select="type"/>'
                            }
                            <xsl:if test="position() != last()">,</xsl:if>
                        </xsl:for-each>
                    ],
                    polygons: 
                    [
                        <xsl:for-each select="pointsOfInterest/entry[type/@value='polygon']">
                        {
                          title: '<xsl:value-of select="ametys:escapeJS(title)"/>',
                          description :'<xsl:value-of select="ametys:escapeJS(description)"/>',
                          color:'<xsl:value-of select="color"/>',
                          gtype: '<xsl:value-of select="type"/>',
                          points: 
                          [
                            <xsl:for-each select="points">
                              {
                                  lat: <xsl:value-of select="@latitude"/>,
                                  lng: <xsl:value-of select="@longitude"/>,
                              }<xsl:if test="position() != last()">,</xsl:if>
                            </xsl:for-each>
                          ]
                        }<xsl:if test="position() != last()">,</xsl:if>
                        </xsl:for-each>
                    ]
                };
	    
                var gmapViewer = new GmapViewer();                          
                gmapViewer.setUp('#<xsl:value-of select="$uniqueId"/>', data);  
            }
        </script>
    
        <xsl:call-template name="google-maps-js">
            <xsl:with-param name="uniqueId" select="$uniqueId" />
        </xsl:call-template>
	</xsl:template>
	
    <!-- +
         | BODY
         + -->    

    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$service-title"/>  
        </xsl:call-template>    
    </xsl:template>

    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="google-maps-body">
            <xsl:with-param name="uniqueId" select="$uniqueId" />
            <xsl:with-param name="class">map</xsl:with-param>
            <xsl:with-param name="mapTypeId" select="mapTypeId" />
            <xsl:with-param name="zoomLevel" select="zoomLevel" />
            <xsl:with-param name="latitude" select="center/@latitude" />
            <xsl:with-param name="longitude" select="center/@longitude" />
            <xsl:with-param name="height" select="$service-height" />
            <xsl:with-param name="pointsOfInterest" select="pointsOfInterest" />
        </xsl:call-template>
    </xsl:template>
</xsl:stylesheet>