<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:stringutils="org.apache.commons.lang.StringUtils"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:xalan="http://xml.apache.org/xalan" 
    xmlns:math="java.lang.Math"
    exclude-result-prefixes="ametys xalan math">

    <xsl:template name="google-maps-js" >
        <xsl:param name="uniqueId" />
    
        <xsl:variable name="scheme" select="substring-before(ametys:absoluteUriPrefix(), '://')"/>
        <script src="{$scheme}://maps.google.com/maps/api/js?key={ametys:siteParameter('google-api-key')}" type="text/javascript"></script>
        <script src="{ametys:pluginResourceURL('web', 'js/jquery.gmap.js')}" type="text/javascript"></script>
        <script src="{ametys:pluginResourceURL('web', 'js/GmapViewer.js')}" type="text/javascript"></script>

        <script type="text/javascript">             
	        $j(document).ready(function () 
	        { 
	            setUpMap_<xsl:value-of select="$uniqueId" />();
	      });
        </script>
    </xsl:template>

    <xsl:template name="google-maps-body" >
        <xsl:param name="uniqueId" />
        <xsl:param name="class" />
        <xsl:param name="mapTypeId" />
        <xsl:param name="zoomLevel" />
        <xsl:param name="latitude" />
        <xsl:param name="longitude" />
        <xsl:param name="height" />
        <xsl:param name="pointsOfInterest" />
        
        <xsl:variable name="lettersRTF">
               <letter>A</letter>
               <letter>B</letter>
               <letter>C</letter>
               <letter>D</letter>
               <letter>E</letter>
               <letter>F</letter>
               <letter>G</letter>
               <letter>H</letter>
               <letter>I</letter>
               <letter>J</letter>
               <letter>K</letter>
               <letter>L</letter>
               <letter>M</letter>
               <letter>N</letter>
               <letter>O</letter>
               <letter>P</letter>
               <letter>Q</letter>
               <letter>R</letter>
               <letter>S</letter>
               <letter>T</letter>
               <letter>U</letter>
               <letter>V</letter>
               <letter>W</letter>
               <letter>X</letter>
               <letter>Y</letter>
               <letter>Z</letter>
           </xsl:variable>
           
           <xsl:variable name="letters" select="xalan:nodeset($lettersRTF)"/>
           
           <xsl:variable name="markers">
               <xsl:for-each select="$pointsOfInterest/entry[type/@value ='marker']">
                   <xsl:variable name="pos" select="position()"/>
                   <xsl:text/>&amp;markers=color:<xsl:value-of select="color"/>%7Clabel:<xsl:value-of select="$letters/letter[$pos]"/>%7C<xsl:value-of select="point/@latitude"/>,<xsl:value-of select="point/@longitude"/>
               </xsl:for-each>
           </xsl:variable>
           
           <xsl:variable name="polygons">
               <xsl:for-each select="$pointsOfInterest/entry[type/@value ='polygon']">
                   <!-- Color are 32 bits values, last 8 bits for opacity. We set opacity to 100% (FF) for the line and 50% (7F) for the background -->
                   <!-- We repeat the last point to close the loop, so that the line is correctly displayed -->
                   <xsl:text/>&amp;path=color:0x<xsl:value-of select="color"/>ff%7Cweight:2%7Cfillcolor:0x<xsl:value-of select="color"/>7f<xsl:for-each select="points">%7C<xsl:value-of select="@latitude"/>,<xsl:value-of select="@longitude"/></xsl:for-each>%7C<xsl:value-of select="points[1]/@latitude"/>,<xsl:value-of select="points/@longitude"/>
               </xsl:for-each>
           </xsl:variable>
           
           <div id="{$uniqueId}" class="{$class}" style="height: {$height}px;">
               <noscript>
                   <p>
                        <img src="http://maps.googleapis.com/maps/api/staticmap?center={$latitude},{$longitude}&amp;zoom={$zoomLevel}&amp;size={math:floor(4 div 3 * $height)}x{$height}&amp;maptype={$mapTypeId}&amp;sensor=false{$markers}{$polygons}" alt=""/>
                   </p>
                   <div class="map-legend">
                       <span class="map-legend-title"><i18n:text i18n:key="PLUGINS_MAPS_SERVICE_MAP_LEGEND"/></span>
                       <ul>
                       <xsl:for-each select="$pointsOfInterest/entry[type/@value ='marker']">
                           <xsl:variable name="pos" select="position()"/>
                           <li>
                               <xsl:value-of select="$letters/letter[$pos]"/> : <img src="{$uri-prefix}/plugins/maps/resources/img/poi/{icon}.png" alt=""/> <span class="point-title"><xsl:value-of select="title"/></span>
                               <xsl:if test="description"><br/><span class="point-desc"><xsl:value-of select="description"/></span></xsl:if>
                           </li> 
                       </xsl:for-each>
                       </ul>
                   </div>
               </noscript>
           </div>
    </xsl:template>
    
</xsl:stylesheet>
