/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.maps;

import java.io.IOException;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.web.repository.page.ZoneItem;

/**
 * Generates a map.
 */
public class MapGenerator extends ServiceableGenerator
{
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
    }
    
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        ZoneItem zoneItem = (ZoneItem) request.getAttribute(ZoneItem.class.getName());
        ModelAwareDataHolder dataHolder = zoneItem.getServiceParameters();
        
        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "map");
        
        dataHolder.dataToSAX(contentHandler);
        
        XMLUtils.endElement(contentHandler, "map");
        contentHandler.endDocument();
    }
}
