/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.messagingconnector.dynamic;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.linkdirectory.dynamic.DynamicInformationException;
import org.ametys.plugins.messagingconnector.CalendarEvent;
import org.ametys.plugins.messagingconnector.MessagingConnectorException;
import org.ametys.plugins.messagingconnector.dynamic.AbstractMessagingConnectorDynamicInformationGenerator;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CalendarDynamicInformationGenerator
extends AbstractMessagingConnectorDynamicInformationGenerator {
    private static final int __DEFAULT_MAX_DAYS = 7;

    protected void saxShortValue() throws SAXException, DynamicInformationException {
        try {
            UserIdentity currentUser = this.getCurrentUser();
            if (currentUser != null) {
                int eventsCount = this._messagingConnector.getEventsCount(currentUser, this.getMaxDays());
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"short-value", (String)String.valueOf(eventsCount));
            } else {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"short-value", (String)"0");
            }
        }
        catch (MessagingConnectorException e) {
            throw e.toDynamicInformationException();
        }
    }

    protected void saxLongValue() throws SAXException, DynamicInformationException {
        try {
            UserIdentity currentUser = this.getCurrentUser();
            if (currentUser != null) {
                int eventsCount = this._messagingConnector.getEventsCount(currentUser, this.getMaxDays());
                String i18nKey = eventsCount > 1 ? "PLUGINS_MESSAGINGCONNECTOR_LINKDIRECTORY_CALENDAR_DISPLAY_MULTIPLE" : "PLUGINS_MESSAGINGCONNECTOR_LINKDIRECTORY_CALENDAR_DISPLAY_SINGLE";
                I18nizableText longValue = new I18nizableText("plugin.messaging-connector", i18nKey, Collections.singletonList(String.valueOf(eventsCount)));
                longValue.toSAX(this.contentHandler, "long-value");
            } else {
                I18nizableText longValue = new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_LINKDIRECTORY_CALENDAR_NO_USER");
                longValue.toSAX(this.contentHandler, "long-value");
            }
        }
        catch (MessagingConnectorException e) {
            throw e.toDynamicInformationException();
        }
    }

    protected void saxTooltips() throws SAXException, DynamicInformationException {
        try {
            UserIdentity currentUser = this.getCurrentUser();
            if (currentUser != null) {
                List<CalendarEvent> events = this._messagingConnector.getEvents(currentUser, this.getMaxDays(), this.getMaxItems());
                for (CalendarEvent calendarEvent : events) {
                    this.saxItem(calendarEvent.getStartDate(), calendarEvent.getSubject(), calendarEvent.getLocation());
                }
            }
        }
        catch (MessagingConnectorException e) {
            throw e.toDynamicInformationException();
        }
    }

    protected int getMaxDays() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        try {
            return Integer.parseInt(request.getParameter("maxDays"));
        }
        catch (NumberFormatException e) {
            return 7;
        }
    }

    @Override
    protected String getSpanId() {
        return "dynamic-info-calendar-change-password-" + StringUtils.generateKey();
    }
}

