/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.messagingconnector.dynamic;

import java.util.Collections;
import java.util.List;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.linkdirectory.dynamic.DynamicInformationException;
import org.ametys.plugins.messagingconnector.EmailMessage;
import org.ametys.plugins.messagingconnector.MessagingConnectorException;
import org.ametys.plugins.messagingconnector.dynamic.AbstractMessagingConnectorDynamicInformationGenerator;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MailDynamicInformationGenerator
extends AbstractMessagingConnectorDynamicInformationGenerator {
    protected void saxShortValue() throws SAXException, DynamicInformationException {
        try {
            UserIdentity currentUser = this.getCurrentUser();
            if (currentUser != null) {
                int unreadEmailCount = this._messagingConnector.getUnreadEmailCount(currentUser);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"short-value", (String)String.valueOf(unreadEmailCount));
            } else {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"short-value", (String)"0");
            }
        }
        catch (MessagingConnectorException e) {
            throw e.toDynamicInformationException();
        }
    }

    protected void saxLongValue() throws SAXException, DynamicInformationException {
        try {
            UserIdentity currentUser = this.getCurrentUser();
            if (currentUser != null) {
                int unreadMailCount = this._messagingConnector.getUnreadEmailCount(currentUser);
                String i18nKey = unreadMailCount > 1 ? "PLUGINS_MESSAGINGCONNECTOR_LINKDIRECTORY_MAIL_DISPLAY_MULTIPLE" : "PLUGINS_MESSAGINGCONNECTOR_LINKDIRECTORY_MAIL_DISPLAY_SINGLE";
                I18nizableText longValue = new I18nizableText("plugin.messaging-connector", i18nKey, Collections.singletonList(String.valueOf(unreadMailCount)));
                longValue.toSAX(this.contentHandler, "long-value");
            } else {
                I18nizableText longValue = new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_LINKDIRECTORY_MAIL_NO_USER");
                longValue.toSAX(this.contentHandler, "long-value");
            }
        }
        catch (MessagingConnectorException e) {
            throw e.toDynamicInformationException();
        }
    }

    protected void saxTooltips() throws SAXException, DynamicInformationException {
        try {
            UserIdentity currentUser = this.getCurrentUser();
            if (currentUser != null) {
                List<EmailMessage> unreadEmails = this._messagingConnector.getUnreadEmails(currentUser, this.getMaxItems());
                for (EmailMessage email : unreadEmails) {
                    this.saxItem(email.getSubject(), email.getSummary(), email.getSender());
                }
            }
        }
        catch (MessagingConnectorException e) {
            throw e.toDynamicInformationException();
        }
    }

    @Override
    protected String getSpanId() {
        return "dynamic-info-agenda-change-password" + StringUtils.generateKey();
    }
}

