/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
var SITE_URI_PREFIX = MessagingConnector.SITE_URI_PREFIX; // To be setted before loading this js file
var LANG = MessagingConnector.LANG; // To be setted before loading this js file

if (!MessagingConnector.insertChangePasswordLink) // be sure the script was not loaded twice simultaneously 
{
	var MessagingConnector = {
	
	    SITE_URI_PREFIX: SITE_URI_PREFIX,
	    LANG: LANG,
	    
	    cssPrefix: 'messaging-change-password-',
	    dialogId: 'messaging-change-password-dialog',
	    linkTemplateId: 'messaging-change-password-link-template',
	    
	    callback: null,
	    callbacks: {},
	    
	    showChangePasswordErrorMessage: function(dialog, message)
		{
		    var elmt = $j(dialog).find('.' + MessagingConnector.cssPrefix + 'error');
		    elmt.text(message);
		    elmt.show();
		},
	        
	    hideChangePasswordErrorMessage: function(dialog)
		{
		    var elmt = $j(dialog).find('.' + MessagingConnector.cssPrefix + 'error');
		    elmt.text("");
		    elmt.hide();
		},
	    
	    changeMessagingConnectorPassword: function(dialog)
		{
		    function setPasswordCb(data)
		    {
		        if (data && data.success == true)
		        {
	                // Invoked callback function
		            MessagingConnector.callback();
		            
		            // Close dialog box
		            dialog.dialog("close");
		        }
		        else if (data && data.success == false)
		        {
		            MessagingConnector.showChangePasswordErrorMessage(dialog, data.message);
		        }
		        else
		        {
		            MessagingConnector.showChangePasswordErrorMessage(dialog, "{{i18n PLUGINS_MESSAGINGCONNECTOR_SUBMIT_PASSWORD_ERROR}}")
		        }
		    }
		    
		    var password = $j(dialog).find("input[type='password']").val();
		    $j.ajax({
		        url: MessagingConnector.SITE_URI_PREFIX + '/_plugins/messaging-connector/set-password.json',
		        method: 'POST',
		        data: {
		            password: password
		        },
		        cache: false,
		        dataType: 'json',
		        success: function(data) {
		            setPasswordCb(data);
		        },
		        error: function() {
		            setPasswordCb();
		        }
		    });
		},
	    
	    /**
	     * Insert a link to open the dialog box to change password
	     * @param uniqueId The id of HTML element to insert the link. If null the link will be insert into a span, at current location.
	     * @param callback The callback function to call after sucessfully updating the password
	     */
	    insertChangePasswordLink: function (uniqueId, callback)
	    {
	        if (!uniqueId)
	        {
	            // Generate unique id
	            uniqueId = Math.random().toString(36).substring(2, 15);
		        document.write("<span id='" + uniqueId + "'><span>");
	        }
	        
	        MessagingConnector.callbacks[uniqueId] = callback;
	        MessagingConnector._insertChangePasswordLink(uniqueId); 
	    },
	    
	    _insertChangePasswordLink: function(uniqueId)
	    {
	        if ($j('#' + MessagingConnector.linkTemplateId))
	        {
		        $j('#' + uniqueId).html($j('#' + MessagingConnector.linkTemplateId).html());
		        $j('#' + uniqueId).find('a').on('click', function() {
		            var dialog = $j('#' + MessagingConnector.dialogId);
		            MessagingConnector.hideChangePasswordErrorMessage(dialog);
	                MessagingConnector.callback = MessagingConnector.callbacks[uniqueId]; 
		            dialog.dialog('open');
		        });
	        }
	    }
	}
	  
	// Get the HTML for the dialog box and the template for the link to open this dialog box
	$j('body').append("<div style='display: none'></div>").children().last().load(MessagingConnector.SITE_URI_PREFIX + '/_plugins/messaging-connector/change-password.' + MessagingConnector.LANG + '.html', function( response, status, xhr ) {
	    
	    // Prepare de dialog box to change password
	    $j('#' + MessagingConnector.dialogId).dialog({
	        autoOpen: false,
	        width: 350,
	        modal: true, 
	        buttons: [
	            {
	                text: "{{i18n PLUGINS_MESSAGINGCONNECTOR_SUBMIT_PASSWORD_DIALOG_OK}}",
	                click: function() {
	                    MessagingConnector.changeMessagingConnectorPassword($j(this));
	                }
	            },
	            {
	                text: "{{i18n PLUGINS_MESSAGINGCONNECTOR_SUBMIT_PASSWORD_DIALOG_CANCEL}}",
	                click: function() {
	                    $j(this).dialog('close');
	                }
	            }
	        ]
	    });
	    
	    for (var uniqueId in MessagingConnector.callbacks)
	    {
	        MessagingConnector._insertChangePasswordLink(uniqueId);
	    }
	});
}
