<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:math="java.lang.Math"
    exclude-result-prefixes="ametys math">
        
    <xsl:template name="messaging-connector-card">
        <xsl:param name="email-title"><i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_CARD_INFOUSER_MESSAGINGCONNECTOR" i18n:catalogue="plugin.messaging-connector"/></xsl:param>
        <xsl:param name="email-waiting"><i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_CARD_INFOUSER_MESSAGINGCONNECTOR_MAILS_WAITING" i18n:catalogue="plugin.messaging-connector"/></xsl:param>
        <xsl:param name="email-error"><i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_CARD_INFOUSER_MESSAGINGCONNECTOR_MAILS_ERROR" i18n:catalogue="plugin.messaging-connector"/></xsl:param>
        <xsl:param name="email-pending"><i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_CARD_INFOUSER_MESSAGINGCONNECTOR_MAILS_PENDING" i18n:catalogue="plugin.messaging-connector"/></xsl:param>
        <xsl:param name="agenda-title"><i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_CARD_INFOUSER_MESSAGINGCONNECTOR_RDV" i18n:catalogue="plugin.messaging-connector"/></xsl:param>
        <xsl:param name="agenda-waiting"><i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_CARD_INFOUSER_MESSAGINGCONNECTOR_RDV_WAITING" i18n:catalogue="plugin.messaging-connector"/></xsl:param>
        <xsl:param name="agenda-error"><i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_CARD_INFOUSER_MESSAGINGCONNECTOR_RDV_ERROR" i18n:catalogue="plugin.messaging-connector"/></xsl:param>
        <xsl:param name="agenda-info-none1"><i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_CARD_INFOUSER_MESSAGINGCONNECTOR_RDV_NONE_PART1" i18n:catalogue="plugin.messaging-connector"/></xsl:param>
        <xsl:param name="agenda-info-none2"><i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_CARD_INFOUSER_MESSAGINGCONNECTOR_RDV_NONE_PART2" i18n:catalogue="plugin.messaging-connector"/></xsl:param>
        <xsl:param name="agenda-info-none3"><i18n:text i18n:key="PLUGINS_MESSAGINGCONNECTOR_CARD_INFOUSER_MESSAGINGCONNECTOR_RDV_NONE_PART3" i18n:catalogue="plugin.messaging-connector"/></xsl:param>
        
        <xsl:param name="css-class-prefix">messaging</xsl:param>
        <xsl:param name="webmail-url"><xsl:value-of select="ametys:config('messagingconnector.webmail.url')"/></xsl:param>
        <xsl:param name="agenda-url"><xsl:value-of select="ametys:config('messagingconnector.agenda.url')"/></xsl:param>
        <xsl:param name="link-target">_self</xsl:param>
        
        <ul>
            <xsl:attribute name="class">user-infos <xsl:value-of select="$css-class-prefix"/>-user-infos</xsl:attribute>
            <xsl:call-template name="person">
                <xsl:with-param name="css-class-prefix" select="$css-class-prefix"/>
            </xsl:call-template>
            <xsl:call-template name="email">
                <xsl:with-param name="email-title"><xsl:copy-of select='$email-title'/></xsl:with-param>
                <xsl:with-param name="email-waiting"><xsl:copy-of select='$email-waiting'/></xsl:with-param>
                <xsl:with-param name="email-error"><xsl:copy-of select='$email-error'/></xsl:with-param>
                <xsl:with-param name="email-pending"><xsl:copy-of select='$email-pending'/></xsl:with-param>
                <xsl:with-param name="css-class-prefix" select="$css-class-prefix"/>
                <xsl:with-param name="webmail-url" select="$webmail-url"/>
                <xsl:with-param name="link-target" select="$link-target"/>
            </xsl:call-template>
            <xsl:call-template name="agenda">
                <xsl:with-param name="agenda-title"><xsl:copy-of select='$agenda-title'/></xsl:with-param>
                <xsl:with-param name="agenda-waiting"><xsl:copy-of select='$agenda-waiting'/></xsl:with-param>
                <xsl:with-param name="agenda-error"><xsl:copy-of select='$agenda-error'/></xsl:with-param>
                <xsl:with-param name="agenda-info-none1"><xsl:copy-of select='$agenda-info-none1'/></xsl:with-param>
                <xsl:with-param name="agenda-info-none2"><xsl:copy-of select='$agenda-info-none2'/></xsl:with-param>
                <xsl:with-param name="agenda-info-none3"><xsl:copy-of select='$agenda-info-none3'/></xsl:with-param>
                <xsl:with-param name="css-class-prefix" select="$css-class-prefix"/>
                <xsl:with-param name="agenda-url" select="$agenda-url"/>
                <xsl:with-param name="link-target" select="$link-target"/>
            </xsl:call-template>
        </ul>
    </xsl:template>
    
    <xsl:template name="person">
        <xsl:param name="css-class-prefix"/>
        <li>
            <xsl:attribute name="class">user-infos-person <xsl:value-of select="$css-class-prefix"/>-user-infos-person</xsl:attribute>
            <xsl:variable name="user" select="ametys:user()"/>
            <span>
                <xsl:attribute name="class">user-infos-person-title  <xsl:value-of select="$css-class-prefix"/>-user-infos-person-title</xsl:attribute>
            <xsl:value-of select="$user/user/firstname"/><xsl:text> </xsl:text><xsl:value-of select="$user/user/lastname"/></span>
        </li>
    </xsl:template>
    
    <xsl:template name="email">
        <xsl:param name="email-title"/>
        <xsl:param name="email-waiting"/>
        <xsl:param name="email-error"/>
        <xsl:param name="email-pending"/>
        <xsl:param name="css-class-prefix"/>
        <xsl:param name="webmail-url"/>
        <xsl:param name="link-target"/>
        
        <li class="user-infos-mail {$css-class-prefix}-user-infos-mail">
            <xsl:choose>
                <xsl:when test="$webmail-url != ''">
                   	<a href="{$webmail-url}" class="user-infos-mail-title {$css-class-prefix}-user-infos-mail-title" rel="noreferrer">
                   	    <xsl:attribute name="target"><xsl:value-of select="$link-target"/></xsl:attribute>
                        <xsl:copy-of select='$email-title'/>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <span class="user-infos-mail-title {$css-class-prefix}-user-infos-mail-title">
                        <xsl:copy-of select='$email-title'/>
                    </span>
                </xsl:otherwise>
            </xsl:choose>
                
            <span class="user-infos-waiting {$css-class-prefix}-user-infos-waiting"><xsl:copy-of select='$email-waiting'/></span>
            <span class="user-infos-error {$css-class-prefix}-user-infos-error" style="display:none;"><xsl:copy-of select='$email-error'/></span>
            <span class="user-infos-error {$css-class-prefix}-user-infos-error-server" style="display:none;"><!-- This must be empty and will contain the server message --></span>
            <span class="user-infos-error {$css-class-prefix}-user-infos-error-change-password" id="email-user-infos-error-change-password" style="display:none;"><!-- This must be empty and will contain the link to change pasword --></span>
            
            <span class="user-infos-info {$css-class-prefix}-user-infos-info" style="display:none;">
                <span id="{$css-class-prefix}-nb-msg"><xsl:comment>empty</xsl:comment></span>
                <xsl:text> </xsl:text>
                <xsl:copy-of select='$email-pending'/>
            </span>
        </li>
    </xsl:template>
    
    <xsl:template name="agenda">
        <xsl:param name="agenda-title"/>
        <xsl:param name="agenda-waiting"/>
        <xsl:param name="agenda-error"/>
        <xsl:param name="agenda-info-none1"/>
        <xsl:param name="agenda-info-none2"/>
        <xsl:param name="agenda-info-none3"/>
        <xsl:param name="css-class-prefix"/>
        <xsl:param name="agenda-url"/>
        <xsl:param name="link-target"/>
        
        <li class="user-infos-agenda {$css-class-prefix}-user-infos-agenda">
            
            <xsl:choose>
                <xsl:when test="$agenda-url != ''">
                    <a href="{$agenda-url}" class="user-infos-agenda-title {$css-class-prefix}-user-infos-agenda-title" rel="noreferrer">
                        <xsl:attribute name="target"><xsl:value-of select="$link-target"/></xsl:attribute>
                        <xsl:copy-of select="$agenda-title"/>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <span class="user-infos-agenda-title {$css-class-prefix}-user-infos-agenda-title">
                        <xsl:copy-of select="$agenda-title"/>
                    </span>
                </xsl:otherwise>
            </xsl:choose>
                    
            <span class="user-infos-waiting {$css-class-prefix}-user-infos-waiting"><xsl:copy-of select='$agenda-waiting'/></span>
            <span class="user-infos-error {$css-class-prefix}-user-infos-error" style="display:none;"><xsl:copy-of select='$agenda-error'/></span>
            <span class="user-infos-error {$css-class-prefix}-user-infos-error-server" style="display:none;"><!-- This must be empty and will contain the server message --></span>
            <span class="user-infos-error {$css-class-prefix}-user-infos-error-change-password" id="agenda-user-infos-error-change-password" style="display:none;"><!-- This must be empty and will contain the link to change pasword --></span>
            
            <ul style="display:none;" class="user-infos-events {$css-class-prefix}-user-infos-events"></ul>
            
            <span style="display:none;" class="user-infos-noevent {$css-class-prefix}-user-infos-noevent">
                <span><xsl:copy-of select="$agenda-info-none1"/></span>
                <xsl:text> </xsl:text>
                <xsl:copy-of select="$agenda-info-none2"/>
                <xsl:text> </xsl:text>
                <span class="user-infos-maxdays {$css-class-prefix}-user-infos-maxdays"></span>
                <xsl:text> </xsl:text>
                <xsl:copy-of select="$agenda-info-none3"/>
            </span>
        </li>
    </xsl:template>
    
</xsl:stylesheet>
