/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.messagingconnector;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.plugins.messagingconnector.MessagingConnector;
import org.ametys.plugins.messagingconnector.MessagingConnectorException;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class SetPasswordAction
extends ServiceableAction {
    private static final String PASSWORD_FIELD = "password";
    protected CurrentUserProvider _currentUserProvider;
    private MessagingConnector _messagingConnector;

    public void service(ServiceManager smanager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._messagingConnector = (MessagingConnector)smanager.lookup(MessagingConnector.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws UserPreferencesException, MessagingConnectorException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        UserIdentity identity = this._currentUserProvider.getUser();
        if (identity != null) {
            String password = request.getParameter(PASSWORD_FIELD);
            if (!StringUtils.isBlank((CharSequence)password)) {
                this._messagingConnector.setUserPassword(identity, password);
                result.put("success", true);
            } else {
                result.put("success", false);
                result.put("error", "password-empty");
                I18nizableText message = new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_ERROR_INPUT_PASSWORD_EMPTY");
                result.put("message", message);
            }
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return EMPTY_MAP;
    }
}

