/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.messagingconnector;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.cache.CacheException;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.CryptoHelper;
import org.ametys.plugins.messagingconnector.CalendarEvent;
import org.ametys.plugins.messagingconnector.EmailMessage;
import org.ametys.plugins.messagingconnector.EventRecurrenceTypeEnum;
import org.ametys.plugins.messagingconnector.MessagingConnector;
import org.ametys.plugins.messagingconnector.MessagingConnectorException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractMessagingConnector
extends AbstractLogEnabled
implements MessagingConnector,
Initializable,
Serviceable {
    private static final int TIMEOUT_CACHE_DURATION_SECONDS = 30;
    private static final String EVENTS_CACHE = AbstractMessagingConnector.class.getName() + "$eventsCache";
    private static final String EVENTS_COUNT_CACHE = AbstractMessagingConnector.class.getName() + "$eventsCountCache";
    private static final String EMAILS_CACHE = AbstractMessagingConnector.class.getName() + "$emailsCache";
    private static final String EMAILS_COUNT_CACHE = AbstractMessagingConnector.class.getName() + "$emailsCountCache";
    private static final String ERROR_CACHE = AbstractMessagingConnector.class.getName() + "$errorCache";
    private static final String TIMEOUT_ERROR_CACHE = AbstractMessagingConnector.class.getName() + "$timeoutErrorCache";
    protected UserPopulationDAO _userPopulationDAO;
    protected UserPreferencesManager _userPref;
    protected CryptoHelper _cryptoHelper;
    protected CurrentUserProvider _currentUserProvider;
    protected AbstractCacheManager _cacheManager;
    private List<String> _populationIds;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._userPref = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE);
        this._cryptoHelper = (CryptoHelper)manager.lookup("org.ametys.plugins.messagingconnector.CryptoHelper");
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() {
        Long cacheTtlConf;
        this._populationIds = new ArrayList<String>();
        String populationIdsAsString = (String)Config.getInstance().getValue("org.ametys.plugins.messagingconnector.population");
        if (StringUtils.isNotBlank((CharSequence)populationIdsAsString)) {
            List userPopulationsIds = this._userPopulationDAO.getUserPopulationsIds();
            String[] populationIds = StringUtils.split((String)populationIdsAsString, (String)",");
            ArrayList<String> wrongPopulationIds = new ArrayList<String>();
            for (String populationId : populationIds) {
                String populationIdTrimed = StringUtils.trim((String)populationId);
                if (!userPopulationsIds.contains(populationIdTrimed)) {
                    wrongPopulationIds.add(populationIdTrimed);
                    continue;
                }
                this._populationIds.add(populationIdTrimed);
            }
            if (!wrongPopulationIds.isEmpty()) {
                throw new IllegalStateException("The following population ids defined in the configuration parameter 'population id' for the messaging connector do not exist : " + String.valueOf(wrongPopulationIds));
            }
        }
        Long cacheTtl = (cacheTtlConf = (Long)Config.getInstance().getValue("org.ametys.plugins.messagingconnector.cache.ttl")) != null && cacheTtlConf.intValue() > 0 ? cacheTtlConf.intValue() : 60;
        if (!this._cacheManager.hasCache(EVENTS_CACHE)) {
            this._cacheManager.createMemoryCache(EVENTS_CACHE, new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_EVENTS_CACHE_LABEL"), new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_EVENTS_CACHE_DESCRIPTION"), true, Duration.ofMinutes(cacheTtl));
        }
        if (!this._cacheManager.hasCache(EVENTS_COUNT_CACHE)) {
            this._cacheManager.createMemoryCache(EVENTS_COUNT_CACHE, new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_EVENTS_COUNT_CACHE_LABEL"), new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_EVENTS_COUNT_CACHE_DESCRIPTION"), true, Duration.ofMinutes(cacheTtl));
        }
        if (!this._cacheManager.hasCache(EMAILS_CACHE)) {
            this._cacheManager.createMemoryCache(EMAILS_CACHE, new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_EMAILS_CACHE_LABEL"), new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_EMAILS_CACHE_DESCRIPTION"), true, Duration.ofMinutes(cacheTtl));
        }
        if (!this._cacheManager.hasCache(EMAILS_COUNT_CACHE)) {
            this._cacheManager.createMemoryCache(EMAILS_COUNT_CACHE, new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_EMAILS_COUNT_CACHE_LABEL"), new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_EMAILS_COUNT_CACHE_DESCRIPTION"), true, Duration.ofMinutes(cacheTtl));
        }
        if (!this._cacheManager.hasCache(ERROR_CACHE)) {
            this._cacheManager.createMemoryCache(ERROR_CACHE, new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_ERROR_CACHE_LABEL"), new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_ERROR_CACHE_DESCRIPTION"), false, Duration.ofMinutes(cacheTtl));
        }
        if (!this._cacheManager.hasCache(TIMEOUT_ERROR_CACHE)) {
            this._cacheManager.createMemoryCache(TIMEOUT_ERROR_CACHE, new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_TIMEOUT_ERROR_CACHE_LABEL"), new I18nizableText("plugin.messaging-connector", "PLUGINS_MESSAGINGCONNECTOR_TIMEOUT_ERROR_CACHE_DESCRIPTION"), true, Duration.ofSeconds(30L));
        }
    }

    @Override
    public List<String> getAllowedPopulationIds() throws MessagingConnectorException {
        if (this._populationIds.isEmpty()) {
            List userPopulationsIds = this._userPopulationDAO.getUserPopulationsIds();
            if (userPopulationsIds.size() == 1) {
                return userPopulationsIds;
            }
            throw new MessagingConnectorException(userPopulationsIds.size() == 0 ? "There are no population defined." : "There is more than one population defined. You must set the configuration parameter 'population id' for the messaging connector");
        }
        return this._populationIds;
    }

    protected boolean isAllowed(UserIdentity userIdentity) {
        if (userIdentity == null) {
            this.getLogger().warn("There is no connected user to get user's mails or events from messaging connector");
            return false;
        }
        List<String> allowedPopulations = this.getAllowedPopulationIds();
        if (!allowedPopulations.contains(userIdentity.getPopulationId())) {
            this.getLogger().warn("The user " + String.valueOf(userIdentity) + " does not belong to any authorized user populations for messaging connector " + String.valueOf(allowedPopulations));
            return false;
        }
        return true;
    }

    @Override
    public List<CalendarEvent> getEvents(UserIdentity userIdentity, int maxDays, int maxEvents) throws MessagingConnectorException {
        if (!this.isAllowed(userIdentity)) {
            return new ArrayList<CalendarEvent>();
        }
        this._throwMessagingConnectorExceptionIfInCache(userIdentity);
        try {
            EventCacheKey eventCacheKey = new EventCacheKey(userIdentity, maxDays, maxEvents);
            return (List)this._getEventsCache().get((Object)eventCacheKey, key -> this.internalGetEvents(userIdentity, maxDays, maxEvents));
        }
        catch (CacheException e) {
            if (e.getCause() instanceof MessagingConnectorException) {
                MessagingConnectorException mce = (MessagingConnectorException)e.getCause();
                this._putExceptionInCache(userIdentity, mce.getType());
                throw mce;
            }
            throw e;
        }
    }

    @Override
    public int getEventsCount(UserIdentity userIdentity, int maxDays) throws MessagingConnectorException {
        if (!this.isAllowed(userIdentity)) {
            return 0;
        }
        this._throwMessagingConnectorExceptionIfInCache(userIdentity);
        try {
            EventCountCacheKey eventCountCacheKey = new EventCountCacheKey(userIdentity, maxDays);
            return (Integer)this._getEventsCountCache().get((Object)eventCountCacheKey, key -> this.internalGetEventsCount(userIdentity, maxDays));
        }
        catch (CacheException e) {
            if (e.getCause() instanceof MessagingConnectorException) {
                MessagingConnectorException mce = (MessagingConnectorException)e.getCause();
                this._putExceptionInCache(userIdentity, mce.getType());
                throw mce;
            }
            throw e;
        }
    }

    @Override
    public List<EmailMessage> getUnreadEmails(UserIdentity userIdentity, int maxEmails) throws MessagingConnectorException {
        if (!this.isAllowed(userIdentity)) {
            return new ArrayList<EmailMessage>();
        }
        this._throwMessagingConnectorExceptionIfInCache(userIdentity);
        try {
            EmailCacheKey emailCacheKey = new EmailCacheKey(userIdentity, maxEmails);
            return (List)this._getEmailsCache().get((Object)emailCacheKey, key -> this.internalGetEmails(userIdentity, maxEmails));
        }
        catch (CacheException e) {
            if (e.getCause() instanceof MessagingConnectorException) {
                MessagingConnectorException mce = (MessagingConnectorException)e.getCause();
                this._putExceptionInCache(userIdentity, mce.getType());
                throw mce;
            }
            throw e;
        }
    }

    @Override
    public int getUnreadEmailCount(UserIdentity userIdentity) throws MessagingConnectorException {
        if (!this.isAllowed(userIdentity)) {
            return 0;
        }
        this._throwMessagingConnectorExceptionIfInCache(userIdentity);
        try {
            return (Integer)this._getEmailsCountCache().get((Object)userIdentity, key -> this.internalGetEmailsCount(userIdentity));
        }
        catch (CacheException e) {
            if (e.getCause() instanceof MessagingConnectorException) {
                MessagingConnectorException mce = (MessagingConnectorException)e.getCause();
                this._putExceptionInCache(userIdentity, mce.getType());
                throw mce;
            }
            throw e;
        }
    }

    protected abstract List<CalendarEvent> internalGetEvents(UserIdentity var1, int var2, int var3) throws MessagingConnectorException;

    protected abstract int internalGetEventsCount(UserIdentity var1, int var2) throws MessagingConnectorException;

    protected abstract List<EmailMessage> internalGetEmails(UserIdentity var1, int var2) throws MessagingConnectorException;

    protected String getUserPassword(UserIdentity userIdentity) throws UserPreferencesException {
        if (this.supportUserCredential(userIdentity)) {
            String encryptedValue = this.getUserCryptedPassword(userIdentity);
            return this._cryptoHelper.decrypt(encryptedValue);
        }
        throw new MessagingConnectorException("Cannot get password for user " + String.valueOf(userIdentity) + ": user credential are not supported by this messaging connector", MessagingConnectorException.ExceptionType.CONFIGURATION_EXCEPTION);
    }

    protected String getUserCryptedPassword(UserIdentity userIdentity) throws UserPreferencesException {
        return this._userPref.getUserPreferenceAsString(userIdentity, "/messaging-connector", Collections.emptyMap(), "messaging-connector-password");
    }

    @Override
    public void setUserPassword(UserIdentity userIdentity, String password) throws UserPreferencesException, MessagingConnectorException {
        if (!this.supportUserCredential(userIdentity)) {
            throw new MessagingConnectorException("Cannot set password for user " + String.valueOf(userIdentity) + ": user credential are not supported by this messaging connector", MessagingConnectorException.ExceptionType.CONFIGURATION_EXCEPTION);
        }
        String cryptedPassword = this._cryptoHelper.encrypt(password);
        this._userPref.addUserPreference(userIdentity, "/messaging-connector", Collections.emptyMap(), "messaging-connector-password", cryptedPassword);
        this._invalidateExceptionForUserInCache(userIdentity, MessagingConnectorException.ExceptionType.UNAUTHORIZED);
    }

    protected abstract int internalGetEmailsCount(UserIdentity var1) throws MessagingConnectorException;

    @Override
    public boolean supportInvitation() throws MessagingConnectorException {
        return false;
    }

    @Override
    public boolean isEventExist(String eventId, UserIdentity organiser) throws MessagingConnectorException {
        this._throwMessagingConnectorExceptionIfInCache(organiser);
        try {
            return this.internalIsEventExist(eventId, organiser);
        }
        catch (MessagingConnectorException e) {
            this._putExceptionInCache(organiser, e.getType());
            throw e;
        }
    }

    protected boolean internalIsEventExist(String eventId, UserIdentity organiser) throws MessagingConnectorException {
        throw new UnsupportedOperationException("Invitation is not implemented for messaging connector");
    }

    @Override
    public String createEvent(String title, String description, String place, boolean isAllDay, ZonedDateTime startDate, ZonedDateTime endDate, EventRecurrenceTypeEnum recurrenceType, ZonedDateTime untilDate, Map<String, Boolean> attendees, UserIdentity organiser) throws MessagingConnectorException {
        this._throwMessagingConnectorExceptionIfInCache(organiser);
        try {
            return this.internalCreateEvent(title, description, place, isAllDay, startDate, endDate, recurrenceType, untilDate, attendees, organiser);
        }
        catch (MessagingConnectorException e) {
            this._putExceptionInCache(organiser, e.getType());
            throw e;
        }
    }

    protected String internalCreateEvent(String title, String description, String place, boolean isAllDay, ZonedDateTime startDate, ZonedDateTime endDate, EventRecurrenceTypeEnum recurrenceType, ZonedDateTime untilDate, Map<String, Boolean> attendees, UserIdentity organiser) throws MessagingConnectorException {
        throw new UnsupportedOperationException("Invitation is not implemented for messaging connector");
    }

    @Override
    public void updateEvent(String eventId, String title, String description, String place, boolean isAllDay, ZonedDateTime startDate, ZonedDateTime endDate, EventRecurrenceTypeEnum recurrenceType, ZonedDateTime untilDate, Map<String, Boolean> attendees, UserIdentity organiser) throws MessagingConnectorException {
        this._throwMessagingConnectorExceptionIfInCache(organiser);
        try {
            this.internalUpdateEvent(eventId, title, description, place, isAllDay, startDate, endDate, recurrenceType, untilDate, attendees, organiser);
        }
        catch (MessagingConnectorException e) {
            this._putExceptionInCache(organiser, e.getType());
            throw e;
        }
    }

    protected void internalUpdateEvent(String eventId, String title, String description, String place, boolean isAllDay, ZonedDateTime startDate, ZonedDateTime endDate, EventRecurrenceTypeEnum recurrenceType, ZonedDateTime untilDate, Map<String, Boolean> attendees, UserIdentity organiser) throws MessagingConnectorException {
        throw new UnsupportedOperationException("Invitation is not implemented for messaging connector");
    }

    @Override
    public void deleteEvent(String eventId, UserIdentity organiser) throws MessagingConnectorException {
        this._throwMessagingConnectorExceptionIfInCache(organiser);
        try {
            this.internalDeleteEvent(eventId, organiser);
        }
        catch (MessagingConnectorException e) {
            this._putExceptionInCache(organiser, e.getType());
            throw e;
        }
    }

    protected void internalDeleteEvent(String eventId, UserIdentity organiser) throws MessagingConnectorException {
        throw new UnsupportedOperationException("Invitation is not implemented for messaging connector");
    }

    @Override
    public Map<String, MessagingConnector.AttendeeInformation> getAttendees(String eventId, UserIdentity organiser) throws MessagingConnectorException {
        this._throwMessagingConnectorExceptionIfInCache(organiser);
        try {
            return this.internalGetAttendees(eventId, organiser);
        }
        catch (MessagingConnectorException e) {
            this._putExceptionInCache(organiser, e.getType());
            throw e;
        }
    }

    protected Map<String, MessagingConnector.AttendeeInformation> internalGetAttendees(String eventId, UserIdentity organiser) throws MessagingConnectorException {
        throw new UnsupportedOperationException("Invitation is not implemented for messaging connector");
    }

    @Override
    public void setAttendees(String eventId, Map<String, Boolean> attendees, UserIdentity organiser) throws MessagingConnectorException {
        this._throwMessagingConnectorExceptionIfInCache(organiser);
        try {
            this.internalSetAttendees(eventId, attendees, organiser);
        }
        catch (MessagingConnectorException e) {
            this._putExceptionInCache(organiser, e.getType());
            throw e;
        }
    }

    protected void internalSetAttendees(String eventId, Map<String, Boolean> attendees, UserIdentity organiser) throws MessagingConnectorException {
        throw new UnsupportedOperationException("Invitation is not implemented for messaging connector");
    }

    @Override
    public Map<String, MessagingConnector.FreeBusyStatus> getFreeBusy(Date startDate, Date endDate, boolean isAllDay, Set<String> attendees, UserIdentity organiser) throws MessagingConnectorException {
        this._throwMessagingConnectorExceptionIfInCache(organiser);
        try {
            return this.internalGetFreeBusy(startDate, endDate, isAllDay, attendees, organiser);
        }
        catch (MessagingConnectorException e) {
            this._putExceptionInCache(organiser, e.getType());
            throw e;
        }
    }

    protected Map<String, MessagingConnector.FreeBusyStatus> internalGetFreeBusy(Date startDate, Date endDate, boolean isAllDay, Set<String> attendees, UserIdentity organiser) throws MessagingConnectorException {
        throw new UnsupportedOperationException("Invitation is not implemented for messaging connector");
    }

    @Override
    public boolean userCredentialNeeded(UserIdentity userIdentity) {
        UserIdentity user;
        boolean credentialNeeded = false;
        if (this.supportUserCredential(userIdentity) && (user = this._currentUserProvider.getUser()) != null) {
            try {
                String password = this.getUserPassword(user);
                if (StringUtils.isEmpty((CharSequence)password)) {
                    credentialNeeded = true;
                }
            }
            catch (UserPreferencesException e) {
                credentialNeeded = true;
            }
        }
        return credentialNeeded;
    }

    @Override
    public boolean supportUserCredential(UserIdentity userIdentity) {
        return false;
    }

    @Override
    public boolean isUserExist(UserIdentity userIdentity) throws MessagingConnectorException {
        throw new UnsupportedOperationException("Invitation is not implemented for messaging connector");
    }

    private void _invalidateExceptionForUserInCache(UserIdentity userIdentity, MessagingConnectorException.ExceptionType type) {
        Set usersInCache = (Set)this._getErrorCache().get((Object)type);
        if (usersInCache != null) {
            usersInCache.remove(userIdentity);
        }
    }

    private void _putExceptionInCache(UserIdentity userIdentity, MessagingConnectorException.ExceptionType type) {
        Cache<MessagingConnectorException.ExceptionType, Set<UserIdentity>> cache = null;
        switch (type) {
            case TIMEOUT: {
                cache = this._getTimeoutErrorCache();
                break;
            }
            default: {
                cache = this._getErrorCache();
            }
        }
        HashSet<UserIdentity> usersInCache = (HashSet<UserIdentity>)cache.get((Object)type);
        if (usersInCache == null) {
            usersInCache = new HashSet<UserIdentity>();
            usersInCache.add(userIdentity);
            cache.put((Object)type, usersInCache);
        } else {
            usersInCache.add(userIdentity);
        }
    }

    private MessagingConnectorException.ExceptionType _getExceptionTypeFromCache(UserIdentity userIdentity) {
        for (Map.Entry entry : this._getErrorCache().asMap().entrySet()) {
            if (!((Set)entry.getValue()).contains(userIdentity)) continue;
            return (MessagingConnectorException.ExceptionType)((Object)entry.getKey());
        }
        for (Map.Entry entry : this._getTimeoutErrorCache().asMap().entrySet()) {
            if (!((Set)entry.getValue()).contains(userIdentity)) continue;
            return (MessagingConnectorException.ExceptionType)((Object)entry.getKey());
        }
        return null;
    }

    private void _throwMessagingConnectorExceptionIfInCache(UserIdentity userIdentity) throws MessagingConnectorException {
        MessagingConnectorException.ExceptionType type = this._getExceptionTypeFromCache(userIdentity);
        if (type != null) {
            throw new MessagingConnectorException(type.name() + " exception was found in cache for user " + String.valueOf(userIdentity) + ". See previous exception to get the real cause.", type);
        }
    }

    private Cache<EventCacheKey, List<CalendarEvent>> _getEventsCache() {
        return this._cacheManager.get(EVENTS_CACHE);
    }

    private Cache<EventCountCacheKey, Integer> _getEventsCountCache() {
        return this._cacheManager.get(EVENTS_COUNT_CACHE);
    }

    private Cache<EmailCacheKey, List<EmailMessage>> _getEmailsCache() {
        return this._cacheManager.get(EMAILS_CACHE);
    }

    private Cache<UserIdentity, Integer> _getEmailsCountCache() {
        return this._cacheManager.get(EMAILS_COUNT_CACHE);
    }

    private Cache<MessagingConnectorException.ExceptionType, Set<UserIdentity>> _getErrorCache() {
        return this._cacheManager.get(ERROR_CACHE);
    }

    private Cache<MessagingConnectorException.ExceptionType, Set<UserIdentity>> _getTimeoutErrorCache() {
        return this._cacheManager.get(TIMEOUT_ERROR_CACHE);
    }

    static class EventCacheKey {
        private UserIdentity _userIdentity;
        private int _maxDays;
        private int _maxEvents;

        public EventCacheKey(UserIdentity userIdentity, int maxDays, int maxEvents) {
            this._userIdentity = userIdentity;
            this._maxDays = maxDays;
            this._maxEvents = maxEvents;
        }

        UserIdentity getUserIdentity() {
            return this._userIdentity;
        }

        int getMaxDays() {
            return this._maxDays;
        }

        int getMaxEvents() {
            return this._maxEvents;
        }

        public int hashCode() {
            return Objects.hash(this._userIdentity, this._maxDays, this._maxEvents);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof EventCacheKey)) {
                return false;
            }
            EventCacheKey toCompare = (EventCacheKey)obj;
            return this._userIdentity.equals((Object)toCompare.getUserIdentity()) && this._maxDays == toCompare.getMaxDays() && this._maxEvents == toCompare.getMaxEvents();
        }
    }

    static class EventCountCacheKey {
        private UserIdentity _userIdentity;
        private int _maxDays;

        public EventCountCacheKey(UserIdentity userIdentity, int maxDays) {
            this._userIdentity = userIdentity;
            this._maxDays = maxDays;
        }

        UserIdentity getUserIdentity() {
            return this._userIdentity;
        }

        int getMaxDays() {
            return this._maxDays;
        }

        public int hashCode() {
            return Objects.hash(this._userIdentity, this._maxDays);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof EventCountCacheKey)) {
                return false;
            }
            EventCountCacheKey toCompare = (EventCountCacheKey)obj;
            return this._userIdentity.equals((Object)toCompare.getUserIdentity()) && this._maxDays == toCompare.getMaxDays();
        }
    }

    static class EmailCacheKey {
        private UserIdentity _userIdentity;
        private int _maxEmails;

        public EmailCacheKey(UserIdentity userIdentity, int maxEmails) {
            this._userIdentity = userIdentity;
            this._maxEmails = maxEmails;
        }

        UserIdentity getUserIdentity() {
            return this._userIdentity;
        }

        int getMaxEmails() {
            return this._maxEmails;
        }

        public int hashCode() {
            return Objects.hash(this._userIdentity, this._maxEmails);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof EmailCacheKey)) {
                return false;
            }
            EmailCacheKey toCompare = (EmailCacheKey)obj;
            return this._userIdentity.equals((Object)toCompare.getUserIdentity()) && this._maxEmails == toCompare.getMaxEmails();
        }
    }
}

